/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.FunctionParameter;
import org.apache.cassandra.cql3.functions.NativeFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;

public abstract class FunctionFactory {
    protected final FunctionName name;
    protected final List<FunctionParameter> parameters;
    private final int numParameters;
    private final int numMandatoryParameters;

    public FunctionFactory(String name, FunctionParameter ... parameters) {
        this.name = FunctionName.nativeFunction(name);
        this.parameters = Arrays.asList(parameters);
        this.numParameters = parameters.length;
        this.numMandatoryParameters = (int)this.parameters.stream().filter(p -> !p.isOptional()).count();
    }

    public FunctionName name() {
        return this.name;
    }

    @Nullable
    public NativeFunction getOrCreateFunction(List<? extends AssignmentTestable> args, AbstractType<?> receiverType, String receiverKeyspace, String receiverTable) {
        FunctionParameter parameter;
        AssignmentTestable arg;
        int i;
        int numArgs = args.size();
        if (numArgs < this.numMandatoryParameters || numArgs > this.numParameters) {
            throw this.invalidNumberOfArgumentsException();
        }
        ArrayList types = new ArrayList(args.size());
        for (i = 0; i < args.size(); ++i) {
            arg = args.get(i);
            parameter = this.parameters.get(i);
            types.add(parameter.inferType("system", arg, receiverType, null));
        }
        for (i = 0; i < args.size(); ++i) {
            arg = args.get(i);
            parameter = this.parameters.get(i);
            AbstractType<?> type = parameter.inferType("system", arg, receiverType, types);
            if (type == null) {
                throw new InvalidRequestException(String.format("Cannot infer type of argument %s in call to function %s: use type casts to disambiguate", arg, this));
            }
            parameter.validateType(this.name, arg, type);
            type = type.udfType();
            types.set(i, type);
        }
        return this.doGetOrCreateFunction(types, receiverType);
    }

    public InvalidRequestException invalidNumberOfArgumentsException() {
        return new InvalidRequestException("Invalid number of arguments for function " + this);
    }

    @Nullable
    protected abstract NativeFunction doGetOrCreateFunction(List<AbstractType<?>> var1, AbstractType<?> var2);

    public String toString() {
        return String.format("%s(%s)", this.name, this.parameters.stream().map(Object::toString).collect(Collectors.joining(", ")));
    }
}

