/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos.cleanup;

import java.io.IOException;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.service.paxos.PaxosRepairHistory;

public class PaxosCleanupHistory {
    final TableId tableId;
    final Ballot highBound;
    final PaxosRepairHistory history;
    public static final IVersionedSerializer<PaxosCleanupHistory> serializer = new IVersionedSerializer<PaxosCleanupHistory>(){

        @Override
        public void serialize(PaxosCleanupHistory message, DataOutputPlus out, int version) throws IOException {
            message.tableId.serialize(out);
            message.highBound.serialize(out);
            PaxosRepairHistory.serializer.serialize(message.history, out, version);
        }

        @Override
        public PaxosCleanupHistory deserialize(DataInputPlus in, int version) throws IOException {
            TableId tableId = TableId.deserialize(in);
            Ballot lowBound = Ballot.deserialize(in);
            PaxosRepairHistory history = (PaxosRepairHistory)PaxosRepairHistory.serializer.deserialize(in, version);
            return new PaxosCleanupHistory(tableId, lowBound, history);
        }

        @Override
        public long serializedSize(PaxosCleanupHistory message, int version) {
            long size = message.tableId.serializedSize();
            size += Ballot.sizeInBytes();
            return size += PaxosRepairHistory.serializer.serializedSize(message.history, version);
        }
    };

    public PaxosCleanupHistory(TableId tableId, Ballot highBound, PaxosRepairHistory history) {
        this.tableId = tableId;
        this.highBound = highBound;
        this.history = history;
    }
}

