/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.util;

import org.psjava.algo.math.PairHash;
import org.psjava.util.EqualityTester;
import org.psjava.util.StrictEqualityTester;

public class Pair<T1, T2>
implements EqualityTester<Pair<T1, T2>> {
    public final T1 v1;
    public final T2 v2;

    public static <T1, T2> Pair<T1, T2> create(T1 v1, T2 v2) {
        return new Pair<T1, T2>(v1, v2);
    }

    public Pair(T1 v1, T2 v2) {
        this.v1 = v1;
        this.v2 = v2;
    }

    public boolean equals(Object obj) {
        return StrictEqualityTester.areEqual(this, obj, this);
    }

    @Override
    public boolean areEqual(Pair<T1, T2> o1, Pair<T1, T2> o2) {
        return o1.v1.equals(o2.v1) && o1.v2.equals(o2.v2);
    }

    public int hashCode() {
        return PairHash.hash(this.v1.hashCode(), this.v2.hashCode());
    }

    public String toString() {
        return "(" + this.v1 + "," + this.v2 + ")";
    }
}

