/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics;

import com.datastax.driver.core.Row;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.cassandra.analytics.DataGenerationUtils;
import org.apache.cassandra.analytics.SharedClusterSparkIntegrationTestBase;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.spark.bulkwriter.WriterOptions;
import org.apache.cassandra.testing.TestUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class QuoteIdentifiersWriteTest
extends SharedClusterSparkIntegrationTestBase {
    static final QualifiedName TABLE_NAME_FOR_UDT_TEST = TestUtils.uniqueTestQuotedKeyspaceQuotedTableFullName((String)"QuOtEd_KeYsPaCe", (String)"QuOtEd_TaBlE");
    static final List<QualifiedName> TABLE_NAMES = Arrays.asList(TestUtils.uniqueTestQuotedKeyspaceTableFullName((String)"QuOtEd_KeYsPaCe"), TestUtils.uniqueTestQuotedKeyspaceTableFullName((String)"keyspace"), TestUtils.uniqueTestKeyspaceQuotedTableFullName((String)"spark_test", (String)"QuOtEd_TaBlE"), new QualifiedName("spark_test", "table", false, true), TABLE_NAME_FOR_UDT_TEST);

    QuoteIdentifiersWriteTest() {
    }

    @ParameterizedTest(name="{index} => table={0}")
    @MethodSource(value={"testInputs"})
    void testQuoteIdentifiersBulkWrite(QualifiedName tableName) {
        SparkSession spark = this.getOrCreateSparkSession();
        boolean udfData = tableName.equals((Object)TABLE_NAME_FOR_UDT_TEST);
        Dataset<org.apache.spark.sql.Row> generatedDf = DataGenerationUtils.generateCourseData(spark, 1000, udfData);
        Dataset df = !udfData ? generatedDf.toDF(new String[]{"IdEnTiFiEr", "course", "limit"}) : generatedDf.toDF(new String[]{"IdEnTiFiEr", "course", "limit", "User_Defined_Type"});
        this.bulkWriterDataFrameWriter((Dataset<org.apache.spark.sql.Row>)df, tableName).option(WriterOptions.QUOTE_IDENTIFIERS.name(), "true").save();
        this.validateWritesWithDriverResultSet(df.collectAsList(), this.queryAllDataWithDriver(tableName), udfData ? QuoteIdentifiersWriteTest::rowWithUdtFormatter : QuoteIdentifiersWriteTest::defaultRowFormatter);
    }

    public static String defaultRowFormatter(Row row) {
        return row.getInt("IdEnTiFiEr") + ":'" + row.getString("course") + "':" + row.getInt("limit");
    }

    @NotNull
    private static String rowWithUdtFormatter(Row row) {
        return row.getInt("IdEnTiFiEr") + ":'" + row.getString("course") + "':" + row.getInt("limit") + ":" + String.valueOf(row.getUDTValue("User_Defined_Type"));
    }

    static Stream<Arguments> testInputs() {
        return TABLE_NAMES.stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    protected void initializeSchemaForTest() {
        String createTableStatement = "CREATE TABLE IF NOT EXISTS %s (\"IdEnTiFiEr\" int, course text, \"limit\" int, PRIMARY KEY(\"IdEnTiFiEr\"));";
        TABLE_NAMES.forEach(name -> {
            this.createTestKeyspace((QualifiedName)name, TestUtils.DC1_RF1);
            if (!name.equals((Object)TABLE_NAME_FOR_UDT_TEST)) {
                this.createTestTable((QualifiedName)name, createTableStatement);
            }
        });
        String createUdtQuery = "CREATE TYPE " + TABLE_NAME_FOR_UDT_TEST.maybeQuotedKeyspace() + ".\"UdT1\" (\"TimE\" bigint, \"limit\" int);";
        this.cluster.schemaChangeIgnoringStoppedInstances(createUdtQuery);
        this.createTestTable(TABLE_NAME_FOR_UDT_TEST, "CREATE TABLE IF NOT EXISTS %s (\"IdEnTiFiEr\" int, course text, \"limit\" int,\"User_Defined_Type\" frozen<\"UdT1\">, PRIMARY KEY(\"IdEnTiFiEr\"));");
    }
}

