/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics.data;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.analytics.SharedClusterSparkIntegrationTestBase;
import org.apache.cassandra.distributed.api.ConsistencyLevel;
import org.apache.cassandra.distributed.shared.Uninterruptibles;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.testing.TestUtils;
import org.apache.spark.sql.DataFrameReader;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

class SecondaryIndexFilterTest
extends SharedClusterSparkIntegrationTestBase {
    static final QualifiedName TABLE_WITH_INDEXES = new QualifiedName("spark_test", "test_secondary_index_filter");
    static final List<String> DATASET = Arrays.asList("alice", "bob", "charlie", "diana", "eve", "frank", "grace", "henry");

    SecondaryIndexFilterTest() {
    }

    @Test
    void testSecondaryIndexFilesAreFilteredFromBulkReader() {
        boolean hasIndexFiles = this.hasSecondaryIndexFiles();
        Assertions.assertThat((boolean)hasIndexFiles).isTrue().as("Secondary index files should exist in the filesystem before bulk reading", new Object[0]);
        DataFrameReader readDf = this.bulkReaderDataFrame(TABLE_WITH_INDEXES).option("snapshotName", "secondaryIndexFilterTest").option("createSnapshot", "true");
        List rows = readDf.load().collectAsList();
        ((ListAssert)Assertions.assertThat((List)rows).hasSize(DATASET.size())).as("Should be able to read all rows despite presence of secondary index files", new Object[0]);
        List actualNames = rows.stream().map(row -> row.getString(3)).sorted().collect(Collectors.toList());
        List expectedNames = DATASET.stream().sorted().collect(Collectors.toList());
        Assertions.assertThat(actualNames).isEqualTo(expectedNames).as("Data should be read correctly when secondary index files are filtered out", new Object[0]);
        boolean hasIndexFilesAfterRead = this.hasSecondaryIndexFiles();
        Assertions.assertThat((boolean)hasIndexFilesAfterRead).isTrue().as("Secondary index files should still exist after bulk reading (just filtered out)", new Object[0]);
    }

    @Test
    void testBulkReaderWorksWithMultipleSecondaryIndexes() {
        String createAdditionalIndex = String.format("CREATE INDEX IF NOT EXISTS age_idx ON %s (age);", TABLE_WITH_INDEXES);
        this.cluster.get(1).coordinator().execute(createAdditionalIndex, ConsistencyLevel.ALL, new Object[0]);
        this.cluster.get(1).coordinator().execute(String.format("SELECT * FROM %s WHERE email = 'alice@test.com';", TABLE_WITH_INDEXES), ConsistencyLevel.ALL, new Object[0]);
        this.cluster.get(1).flush("spark_test");
        boolean hasIndexFiles = this.hasSecondaryIndexFiles();
        Assertions.assertThat((boolean)hasIndexFiles).isTrue().as("Secondary index files should exist", new Object[0]);
        DataFrameReader readDf = this.bulkReaderDataFrame(TABLE_WITH_INDEXES).option("snapshotName", "multipleIndexesTest").option("createSnapshot", "true");
        List rows = readDf.load().collectAsList();
        ((ListAssert)Assertions.assertThat((List)rows).hasSize(DATASET.size())).as("Should successfully read data even with multiple secondary indexes", new Object[0]);
    }

    private void populateTableAndFlush(QualifiedName tableName) {
        for (int i = 0; i < DATASET.size(); ++i) {
            String name = DATASET.get(i);
            String email = name + "@test.com";
            int age = 20 + i;
            String status = i % 2 == 0 ? "active" : "inactive";
            String query = String.format("INSERT INTO %s (id, name, email, age, status) VALUES (%d, '%s', '%s', %d, '%s');", tableName, i, name, email, age, status);
            this.cluster.get(1).coordinator().execute(query, ConsistencyLevel.ALL, new Object[0]);
        }
        this.cluster.get(1).flush("spark_test");
        this.cluster.get(1).coordinator().execute(String.format("SELECT * FROM %s WHERE email = 'alice@test.com';", tableName), ConsistencyLevel.ALL, new Object[0]);
        this.cluster.get(1).coordinator().execute(String.format("SELECT * FROM %s WHERE status = 'active';", tableName), ConsistencyLevel.ALL, new Object[0]);
        Uninterruptibles.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
        this.cluster.get(1).flush("spark_test");
    }

    private boolean hasSecondaryIndexFiles() {
        boolean bl;
        block8: {
            String[] dataDirs = (String[])this.cluster.get(1).config().getParams().get("data_file_directories");
            String dataDir = dataDirs[0];
            Path keyspacePath = Paths.get(dataDir, "spark_test");
            Stream<Path> walkStream = Files.walk(keyspacePath, new FileVisitOption[0]);
            try {
                bl = walkStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).anyMatch(path -> {
                    String fileName = path.getFileName().toString();
                    return fileName.contains(".") && (fileName.contains("index") || fileName.contains("idx") || path.toString().contains(".indexes/") || path.getParent().getFileName().toString().contains("index"));
                });
                if (walkStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walkStream != null) {
                        try {
                            walkStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            walkStream.close();
        }
        return bl;
    }

    protected void initializeSchemaForTest() {
        this.createTestKeyspace("spark_test", TestUtils.DC1_RF1);
        String createTableStatement = "CREATE TABLE IF NOT EXISTS %s (id int PRIMARY KEY, name text, email text, age int, status text);";
        this.createTestTable(TABLE_WITH_INDEXES, createTableStatement);
        String createEmailIndex = String.format("CREATE INDEX IF NOT EXISTS email_idx ON %s (email);", TABLE_WITH_INDEXES);
        String createStatusIndex = String.format("CREATE INDEX IF NOT EXISTS status_idx ON %s (status);", TABLE_WITH_INDEXES);
        this.cluster.get(1).coordinator().execute(createEmailIndex, ConsistencyLevel.ALL, new Object[0]);
        this.cluster.get(1).coordinator().execute(createStatusIndex, ConsistencyLevel.ALL, new Object[0]);
        this.populateTableAndFlush(TABLE_WITH_INDEXES);
    }
}

