/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.token;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.token.ConsistencyLevel;
import org.apache.cassandra.spark.bulkwriter.token.ReplicaAwareFailureHandler;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.apache.cassandra.spark.common.model.CassandraInstance;
import org.apache.cassandra.spark.common.model.NodeStatus;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.jetbrains.annotations.Nullable;

class SingleClusterReplicaAwareFailureHandler<I extends CassandraInstance>
extends ReplicaAwareFailureHandler<I> {
    @GuardedBy(value="this")
    private final RangeMap<BigInteger, ReplicaAwareFailureHandler.FailuresPerInstance> rangeFailuresMap = TreeRangeMap.create();
    @GuardedBy(value="this")
    private boolean isEmpty = true;
    @Nullable
    private final String clusterId;

    SingleClusterReplicaAwareFailureHandler(Partitioner partitioner, @Nullable String clusterId) {
        this.clusterId = clusterId;
        this.rangeFailuresMap.put(Range.openClosed((Comparable)partitioner.minToken(), (Comparable)partitioner.maxToken()), (Object)new ReplicaAwareFailureHandler.FailuresPerInstance());
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public List<ReplicaAwareFailureHandler.ConsistencyFailurePerRange> getFailedRanges(TokenRangeMapping<I> tokenRangeMapping, JobInfo job, ClusterInfo cluster) {
        return this.getFailedRangesInternal(tokenRangeMapping, job.getConsistencyLevel(), job.getLocalDC(), cluster.replicationFactor());
    }

    @Override
    public synchronized void addFailure(Range<BigInteger> tokenRange, I instance, String errMessage) {
        RangeMap overlappingFailures = this.rangeFailuresMap.subRangeMap(tokenRange);
        TreeRangeMap mappingsToAdd = TreeRangeMap.create();
        for (Map.Entry entry : overlappingFailures.asMapOfRanges().entrySet()) {
            ReplicaAwareFailureHandler.FailuresPerInstance newErrorMap = ((ReplicaAwareFailureHandler.FailuresPerInstance)entry.getValue()).copy();
            newErrorMap.addErrorForInstance(instance, errMessage);
            mappingsToAdd.put((Range)entry.getKey(), (Object)newErrorMap);
        }
        this.rangeFailuresMap.putAll((RangeMap)mappingsToAdd);
        this.isEmpty = false;
    }

    @Override
    public synchronized Set<I> getFailedInstances() {
        if (this.isEmpty) {
            return Collections.emptySet();
        }
        return this.rangeFailuresMap.asMapOfRanges().values().stream().map(ReplicaAwareFailureHandler.FailuresPerInstance::instances).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    protected synchronized List<ReplicaAwareFailureHandler.ConsistencyFailurePerRange> getFailedRangesInternal(TokenRangeMapping<I> tokenRangeMapping, ConsistencyLevel cl, @Nullable String localDC, ReplicationFactor replicationFactor) {
        Preconditions.checkArgument((cl.isLocal() && localDC != null || !cl.isLocal() && localDC == null ? 1 : 0) != 0, (Object)("Not a valid pair of consistency level configuration. Consistency level: " + String.valueOf(cl) + " localDc: " + localDC));
        ArrayList<ReplicaAwareFailureHandler.ConsistencyFailurePerRange> failedRanges = new ArrayList<ReplicaAwareFailureHandler.ConsistencyFailurePerRange>();
        if (this.isEmpty) {
            return failedRanges;
        }
        for (Map.Entry failedRangeEntry : this.rangeFailuresMap.asMapOfRanges().entrySet()) {
            Range range = (Range)failedRangeEntry.getKey();
            ReplicaAwareFailureHandler.FailuresPerInstance errorMap = (ReplicaAwareFailureHandler.FailuresPerInstance)failedRangeEntry.getValue();
            Set failedReplicas = errorMap.instances().stream().filter(errorMap::hasError).collect(Collectors.toSet());
            if (failedReplicas.isEmpty()) continue;
            tokenRangeMapping.getWriteReplicasOfRange((Range<BigInteger>)range, instance -> {
                boolean shouldKeep;
                boolean bl = shouldKeep = localDC == null || instance.datacenter().equalsIgnoreCase(localDC);
                if (shouldKeep && this.clusterId != null) {
                    shouldKeep = this.clusterId.equalsIgnoreCase(instance.clusterId());
                }
                return shouldKeep;
            }).forEach((subrange, liveAndDown) -> {
                if (!this.checkSubrange(cl, localDC, replicationFactor, (Set<I>)liveAndDown, failedReplicas)) {
                    failedRanges.add(new ReplicaAwareFailureHandler.ConsistencyFailurePerRange((Range<BigInteger>)subrange, errorMap));
                }
            });
        }
        return failedRanges;
    }

    private boolean checkSubrange(ConsistencyLevel cl, @Nullable String localDC, ReplicationFactor replicationFactor, Set<I> liveAndDown, Set<I> failedReplicas) {
        HashSet<CassandraInstance> pendingReplicas = new HashSet<CassandraInstance>();
        HashSet<CassandraInstance> succeededReplicas = new HashSet<CassandraInstance>();
        for (CassandraInstance instance : liveAndDown) {
            if (instance.nodeStatus() == NodeStatus.UP && !failedReplicas.contains(instance)) {
                succeededReplicas.add(instance);
            }
            if (!instance.nodeState().isPending) continue;
            pendingReplicas.add(instance);
        }
        return cl.canBeSatisfied(succeededReplicas, pendingReplicas, replicationFactor, localDC);
    }
}

