/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.request;

import org.apache.cassandra.sidecar.common.request.JsonRequest;
import org.jetbrains.annotations.Nullable;

abstract class SnapshotRequest<T>
extends JsonRequest<T> {
    SnapshotRequest(String keyspace, String table, String snapshotName) {
        super(SnapshotRequest.requestURI(keyspace, table, snapshotName, false, null));
    }

    SnapshotRequest(String keyspace, String table, String snapshotName, boolean includeSecondaryIndexFiles, @Nullable String snapshotTTL) {
        super(SnapshotRequest.requestURI(keyspace, table, snapshotName, includeSecondaryIndexFiles, snapshotTTL));
    }

    static String requestURI(String keyspace, String tableName, String snapshotName, boolean includeSecondaryIndexFiles, @Nullable String snapshotTTL) {
        Object requestUri = "/api/v1/keyspaces/:keyspace/tables/:table/snapshots/:snapshot".replaceAll(":keyspace", keyspace).replaceAll(":table", tableName).replaceAll(":snapshot", snapshotName);
        if (!includeSecondaryIndexFiles && snapshotTTL == null) {
            return requestUri;
        }
        requestUri = (String)requestUri + "?";
        if (includeSecondaryIndexFiles) {
            requestUri = (String)requestUri + "includeSecondaryIndexFiles=true";
        }
        if (snapshotTTL != null) {
            requestUri = (String)requestUri + "ttl=" + snapshotTTL;
        }
        return requestUri;
    }
}

