/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.cassandra.bridge.SSTableDescriptor;
import org.apache.cassandra.bridge.SSTableWriter;
import org.apache.cassandra.spark.bulkwriter.SortedSSTableWriter;
import org.apache.cassandra.spark.utils.DigestAlgorithm;
import org.apache.commons.io.FileUtils;

public class MockTableWriter
implements SSTableWriter {
    private static final String BASE_NAME = "/test-test-me-1-big-";
    private static final String[] TABLE_COMPONENTS = new String[]{"Data.db", "Index.db", "Filter.db", "CompressionInfo.db", "Statistics.db", "Digest.crc32", "Summary.db", "TOC.txt"};
    private Path outDir;
    private boolean addRowThrows;
    private final ArrayList<Object[]> rows = new ArrayList();
    private boolean closed = false;

    public MockTableWriter(Path outDir) {
        this.outDir = outDir;
    }

    public MockTableWriter setOutDir(Path outDir) {
        this.outDir = outDir;
        return this;
    }

    public void setAddRowThrows(boolean addRowThrows) {
        this.addRowThrows = addRowThrows;
    }

    public void addRow(Map<String, Object> values) throws IOException {
        if (this.addRowThrows) {
            throw new RuntimeException("Failed to write because addRow throws");
        }
        this.rows.add(values.values().toArray());
    }

    public void setSSTablesProducedListener(Consumer<Set<SSTableDescriptor>> listener) {
    }

    public void close() throws IOException {
        for (String component : TABLE_COMPONENTS) {
            Path path = Paths.get(this.outDir.toString(), BASE_NAME + component);
            System.out.format("Writing mock component %s\n", path);
            Files.createFile(path, new FileAttribute[0]);
        }
        this.closed = true;
    }

    @VisibleForTesting
    public Path getOutDir() {
        return this.outDir;
    }

    @VisibleForTesting
    public void removeOutDir() throws IOException {
        FileUtils.deleteDirectory((File)this.outDir.toFile());
    }

    public static interface Creator {
        public SortedSSTableWriter create(MockTableWriter var1, Path var2, DigestAlgorithm var3, int var4);
    }
}

