/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.cassandra.auth.AuthCache;
import org.apache.cassandra.auth.AuthKeyspace;
import org.apache.cassandra.auth.AuthProperties;
import org.apache.cassandra.auth.CIDRPermissions;
import org.apache.cassandra.auth.CIDRPermissionsManagerMBean;
import org.apache.cassandra.auth.CassandraAuthorizer;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.auth.Roles;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.reads.range.RangeCommands;
import org.apache.cassandra.transport.Dispatcher;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.MBeanWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CIDRPermissionsManager
implements CIDRPermissionsManagerMBean,
AuthCache.BulkLoader<RoleResource, CIDRPermissions> {
    public static final String MBEAN_NAME = "org.apache.cassandra.db:type=CIDRPermissionsManager";
    private static final Logger logger = LoggerFactory.getLogger(CIDRPermissionsManager.class);
    private SelectStatement getCidrPermissionsOfUserStatement = null;

    public void setup() {
        if (!MBeanWrapper.instance.isRegistered(MBEAN_NAME)) {
            MBeanWrapper.instance.registerMBean((Object)this, MBEAN_NAME);
        }
        String getCidrPermissionsOfUserQuery = String.format("SELECT %s FROM %s.%s WHERE %s = ?", "cidr_groups", "system_auth", "cidr_permissions", "role");
        this.getCidrPermissionsOfUserStatement = (SelectStatement)QueryProcessor.getStatement(getCidrPermissionsOfUserQuery, ClientState.forInternalCalls());
    }

    @VisibleForTesting
    ResultMessage.Rows select(SelectStatement statement, QueryOptions options) {
        return statement.execute(QueryState.forInternalCalls(), options, Dispatcher.RequestTime.forImmediateExecution());
    }

    @VisibleForTesting
    UntypedResultSet process(String query, ConsistencyLevel cl) throws RequestExecutionException {
        return QueryProcessor.process(query, cl);
    }

    private Set<String> getAuthorizedCIDRGroups(String name) {
        QueryOptions options = QueryOptions.forInternalCalls(CassandraAuthorizer.authReadConsistencyLevel(), Lists.newArrayList(ByteBufferUtil.bytes(name)));
        ResultMessage.Rows rows = this.select(this.getCidrPermissionsOfUserStatement, options);
        UntypedResultSet result = UntypedResultSet.create(rows.result);
        if (!result.isEmpty() && result.one().has("cidr_groups")) {
            return result.one().getFrozenSet("cidr_groups", UTF8Type.instance);
        }
        return Collections.emptySet();
    }

    private static String getCidrPermissionsSetString(CIDRPermissions permissions) {
        String inner = "";
        if (permissions.restrictsAccess()) {
            inner = permissions.allowedCIDRGroups().stream().map(s2 -> "'" + s2 + "'").collect(Collectors.joining(", "));
        }
        return "{" + inner + "}";
    }

    public CIDRPermissions getCidrPermissionsForRole(RoleResource role) {
        if (!Roles.canLogin(role)) {
            return CIDRPermissions.none();
        }
        if (Roles.hasSuperuserStatus(role) && !DatabaseDescriptor.getCidrChecksForSuperusers()) {
            return CIDRPermissions.all();
        }
        Set<String> cidrGroups = this.getAuthorizedCIDRGroups(role.getRoleName());
        if (cidrGroups == null || cidrGroups.isEmpty()) {
            return CIDRPermissions.all();
        }
        return CIDRPermissions.subset(cidrGroups);
    }

    public void setCidrGroupsForRole(RoleResource role, CIDRPermissions cidrPermissions) {
        String query = String.format("UPDATE %s.%s SET %s = %s WHERE %s = '%s'", "system_auth", "cidr_permissions", "cidr_groups", CIDRPermissionsManager.getCidrPermissionsSetString(cidrPermissions), "role", role.getRoleName());
        this.process(query, CassandraAuthorizer.authWriteConsistencyLevel());
    }

    public void drop(RoleResource role) {
        String query = String.format("DELETE FROM %s.%s WHERE role = '%s'", "system_auth", "cidr_permissions", role.getRoleName());
        this.process(query, CassandraAuthorizer.authWriteConsistencyLevel());
    }

    @Override
    public Supplier<Map<RoleResource, CIDRPermissions>> bulkLoader() {
        return () -> {
            if (!RangeCommands.sufficientLiveNodesForSelectStar(AuthKeyspace.metadata().tables.getNullable("cidr_permissions"), AuthProperties.instance.getReadConsistencyLevel())) {
                throw new RuntimeException("insufficient live nodes for " + AuthProperties.instance.getReadConsistencyLevel() + "pre-warm query again system_auth.cidr_permissions");
            }
            logger.info("Pre-warming CIDR permissions cache from cidr_permissions table");
            HashMap<RoleResource, CIDRPermissions> entries = new HashMap<RoleResource, CIDRPermissions>();
            UntypedResultSet rows = this.process(String.format("SELECT %s, %s FROM %s.%s", "role", "cidr_groups", "system_auth", "cidr_permissions"), CassandraAuthorizer.authReadConsistencyLevel());
            for (UntypedResultSet.Row row : rows) {
                RoleResource role = RoleResource.role(row.getString("role"));
                CIDRPermissions.Builder builder = new CIDRPermissions.Builder();
                Set<String> cidrGroups = row.getFrozenSet("cidr_groups", UTF8Type.instance);
                for (String cidrGroup : cidrGroups) {
                    builder.add(cidrGroup);
                }
                entries.put(role, builder.build());
            }
            return entries;
        };
    }

    @Override
    public boolean invalidateCidrPermissionsCache(String roleName) {
        return DatabaseDescriptor.getCIDRAuthorizer().invalidateCidrPermissionsCache(roleName);
    }
}

