/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.apache.cassandra.cql3.functions.AggregateFcts;
import org.apache.cassandra.cql3.functions.BytesConversionFcts;
import org.apache.cassandra.cql3.functions.CastFcts;
import org.apache.cassandra.cql3.functions.CollectionFcts;
import org.apache.cassandra.cql3.functions.FromJsonFct;
import org.apache.cassandra.cql3.functions.FunctionFactory;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.MathFcts;
import org.apache.cassandra.cql3.functions.NativeFunction;
import org.apache.cassandra.cql3.functions.OperationFcts;
import org.apache.cassandra.cql3.functions.TimeFcts;
import org.apache.cassandra.cql3.functions.ToJsonFct;
import org.apache.cassandra.cql3.functions.TokenFct;
import org.apache.cassandra.cql3.functions.UuidFcts;
import org.apache.cassandra.cql3.functions.VectorFcts;
import org.apache.cassandra.cql3.functions.masking.MaskingFcts;

public class NativeFunctions {
    public static NativeFunctions instance = new NativeFunctions(){
        {
            TokenFct.addFunctionsTo(this);
            CastFcts.addFunctionsTo(this);
            UuidFcts.addFunctionsTo(this);
            TimeFcts.addFunctionsTo(this);
            ToJsonFct.addFunctionsTo(this);
            FromJsonFct.addFunctionsTo(this);
            OperationFcts.addFunctionsTo(this);
            AggregateFcts.addFunctionsTo(this);
            CollectionFcts.addFunctionsTo(this);
            BytesConversionFcts.addFunctionsTo(this);
            MathFcts.addFunctionsTo(this);
            MaskingFcts.addFunctionsTo(this);
            VectorFcts.addFunctionsTo(this);
        }
    };
    private final Multimap<FunctionName, NativeFunction> functions = HashMultimap.create();
    private final Multimap<FunctionName, FunctionFactory> factories = HashMultimap.create();

    public void add(NativeFunction function) {
        this.functions.put(function.name(), function);
        NativeFunction legacyFunction = function.withLegacyName();
        if (legacyFunction != null) {
            this.functions.put(legacyFunction.name(), legacyFunction);
        }
    }

    public void addAll(NativeFunction ... functions) {
        for (NativeFunction function : functions) {
            this.add(function);
        }
    }

    public void add(FunctionFactory factory) {
        this.factories.put(factory.name(), factory);
    }

    public Collection<NativeFunction> getFunctions(FunctionName name) {
        return this.functions.get(name);
    }

    public Collection<NativeFunction> getFunctions() {
        return this.functions.values();
    }

    public Collection<FunctionFactory> getFactories(FunctionName name) {
        return this.factories.get(name);
    }

    public Collection<FunctionFactory> getFactories() {
        return this.factories.values();
    }

    public boolean hasFactory(FunctionName name) {
        return this.factories.containsKey(name);
    }
}

