/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.NoSpamLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class ExpirationDateOverflowHandling {
    private static final Logger logger = LoggerFactory.getLogger(ExpirationDateOverflowHandling.class);
    private static final int EXPIRATION_OVERFLOW_WARNING_INTERVAL_MINUTES = CassandraRelevantProperties.EXPIRATION_OVERFLOW_WARNING_INTERVAL_MINUTES.getInt();
    @VisibleForTesting
    public static ExpirationDateOverflowPolicy policy;
    public static final String MAXIMUM_EXPIRATION_DATE_EXCEEDED_WARNING = "Request on table {}.{} with {}ttl of {} seconds exceeds maximum supported expiration date of {} and will have its expiration capped to that date. In order to avoid this use a lower TTL or upgrade to a version where this limitation is fixed. See CASSANDRA-14092 and CASSANDRA-14227 for more details.";
    public static final String MAXIMUM_EXPIRATION_DATE_EXCEEDED_REJECT_MESSAGE = "Request on table %s.%s with %sttl of %d seconds exceeds maximum supported expiration date of %s. In order to avoid this use a lower TTL, change the expiration date overflow policy or upgrade to a version where this limitation is fixed. See CASSANDRA-14092 and CASSANDRA-14227 for more details.";

    public static void maybeApplyExpirationDateOverflowPolicy(TableMetadata metadata, int ttl, boolean isDefaultTTL) throws InvalidRequestException {
        if (ttl == 0) {
            return;
        }
        long nowInSecs = Clock.Global.currentTimeMillis() / 1000L;
        if ((long)ttl + nowInSecs > Cell.getVersionedMaxDeletiontionTime()) {
            switch (policy) {
                case CAP: {
                    ClientWarn.instance.warn(MessageFormatter.arrayFormat((String)MAXIMUM_EXPIRATION_DATE_EXCEEDED_WARNING, (Object[])new Object[]{metadata.keyspace, metadata.name, isDefaultTTL ? "default " : "", ttl, ExpirationDateOverflowHandling.getMaxExpirationDateTS()}).getMessage());
                }
                case CAP_NOWARN: {
                    NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, (long)EXPIRATION_OVERFLOW_WARNING_INTERVAL_MINUTES, TimeUnit.MINUTES, MAXIMUM_EXPIRATION_DATE_EXCEEDED_WARNING, metadata.keyspace, metadata.name, isDefaultTTL ? "default " : "", ttl, ExpirationDateOverflowHandling.getMaxExpirationDateTS());
                    return;
                }
            }
            throw new InvalidRequestException(String.format(MAXIMUM_EXPIRATION_DATE_EXCEEDED_REJECT_MESSAGE, metadata.keyspace, metadata.name, isDefaultTTL ? "default " : "", ttl, ExpirationDateOverflowHandling.getMaxExpirationDateTS()));
        }
    }

    public static long computeLocalExpirationTime(long nowInSec, int timeToLive) {
        long localExpirationTime = nowInSec + (long)timeToLive;
        long cellMaxDeletionTime = Cell.getVersionedMaxDeletiontionTime();
        return localExpirationTime <= cellMaxDeletionTime ? localExpirationTime : cellMaxDeletionTime;
    }

    private static String getMaxExpirationDateTS() {
        return Cell.getVersionedMaxDeletiontionTime() == 0x7FFFFFFEL ? "2038-01-19T03:14:06+00:00" : "2106-02-07T06:28:13+00:00";
    }

    static {
        try {
            policy = CassandraRelevantProperties.EXPIRATION_DATE_OVERFLOW_POLICY.getEnum(ExpirationDateOverflowPolicy.REJECT);
        }
        catch (RuntimeException e) {
            logger.warn("Invalid expiration date overflow policy. Using default: {}", (Object)ExpirationDateOverflowPolicy.REJECT.name());
            policy = ExpirationDateOverflowPolicy.REJECT;
        }
    }

    public static enum ExpirationDateOverflowPolicy {
        REJECT,
        CAP_NOWARN,
        CAP;

    }
}

