/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.streaming;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.db.streaming.ComponentManifest;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentContext
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ComponentContext.class);
    private final Map<Component, File> hardLinks;
    private final ComponentManifest manifest;

    private ComponentContext(Map<Component, File> hardLinks, ComponentManifest manifest) {
        this.hardLinks = hardLinks;
        this.manifest = manifest;
    }

    public static ComponentContext create(SSTable sstable) {
        Descriptor descriptor = sstable.descriptor;
        HashMap<Component, File> hardLinks = new HashMap<Component, File>(1);
        for (Component component : descriptor.getFormat().mutableComponents()) {
            File file = descriptor.fileFor(component);
            if (!file.exists()) continue;
            File hardlink = descriptor.tmpFileForStreaming(component);
            FileUtils.createHardLink(file, hardlink);
            hardLinks.put(component, hardlink);
        }
        return new ComponentContext(hardLinks, ComponentManifest.create(sstable));
    }

    public ComponentManifest manifest() {
        return this.manifest;
    }

    public FileChannel channel(Descriptor descriptor, Component component, long size) throws IOException {
        File toTransfer = this.hardLinks.containsKey(component) ? this.hardLinks.get(component) : descriptor.fileFor(component);
        FileChannel channel = toTransfer.newReadChannel();
        assert (size == channel.size()) : String.format("Entire sstable streaming expects %s file size to be %s but got %s.", component, size, channel.size());
        return channel;
    }

    @Override
    public void close() {
        Throwable accumulate = null;
        for (File file : this.hardLinks.values()) {
            accumulate = FileUtils.deleteWithConfirm(file, accumulate);
        }
        this.hardLinks.clear();
        if (accumulate != null) {
            logger.warn("Failed to remove hard link files", accumulate);
        }
    }
}

