/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.cassandra.cql3.statements.schema.CreateTableStatement;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.db.virtual.SimpleDataSet;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.streaming.StreamManager;
import org.apache.cassandra.streaming.StreamingState;
import org.apache.cassandra.utils.TimeUUID;

public class StreamingVirtualTable
extends AbstractVirtualTable {
    public StreamingVirtualTable(String keyspace) {
        super(CreateTableStatement.parse("CREATE TABLE streaming (  id timeuuid,\n  follower boolean,\n  operation text, \n  peers frozen<list<text>>,\n  status text,\n  progress_percentage float,\n  last_updated_at timestamp,\n  duration_millis bigint,\n  failure_cause text,\n  success_message text,\n\n" + StreamingState.Sessions.columns() + "\n" + StreamingVirtualTable.stateColumns() + "\nPRIMARY KEY ((id)))", keyspace).kind(TableMetadata.Kind.VIRTUAL).build());
    }

    private static String stateColumns() {
        StringBuilder sb = new StringBuilder();
        for (StreamingState.Status state : StreamingState.Status.values()) {
            sb.append("  status_").append(state.name().toLowerCase()).append("_timestamp timestamp,\n");
        }
        return sb.toString();
    }

    @Override
    public AbstractVirtualTable.DataSet data() {
        SimpleDataSet result = new SimpleDataSet(this.metadata());
        StreamManager.instance.getStreamingStates().forEach(s2 -> this.updateDataSet(result, (StreamingState)s2));
        return result;
    }

    @Override
    public AbstractVirtualTable.DataSet data(DecoratedKey partitionKey) {
        TimeUUID id = (TimeUUID)TimeUUIDType.instance.compose(partitionKey.getKey());
        SimpleDataSet result = new SimpleDataSet(this.metadata());
        StreamingState state = StreamManager.instance.getStreamingState(id);
        if (state != null) {
            this.updateDataSet(result, state);
        }
        return result;
    }

    private void updateDataSet(SimpleDataSet ds, StreamingState state) {
        ds.row(state.id());
        ds.column("last_updated_at", new Date(state.lastUpdatedAtMillis()));
        ds.column("follower", state.follower());
        ds.column("operation", state.operation().getDescription());
        ds.column("peers", state.peers().stream().map(Object::toString).collect(Collectors.toList()));
        ds.column("status", state.status().name().toLowerCase());
        ds.column("progress_percentage", Float.valueOf(StreamingVirtualTable.round(state.progress() * 100.0f)));
        ds.column("duration_millis", state.durationMillis());
        ds.column("failure_cause", state.failureCause());
        ds.column("success_message", state.successMessage());
        for (Map.Entry<StreamingState.Status, Long> e : state.stateTimesMillis().entrySet()) {
            ds.column("status_" + e.getKey().name().toLowerCase() + "_timestamp", new Date(e.getValue()));
        }
        state.sessions().update(ds);
    }

    static float round(float value) {
        return Math.round(value * 100.0f) / 100;
    }
}

