/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.io;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.index.sai.disk.io.IndexFileUtils;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.lucene.store.IndexOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class IndexOutputWriter
extends IndexOutput {
    private static final Logger logger = LoggerFactory.getLogger(IndexOutputWriter.class);
    private final SequentialWriter out;
    private boolean closed;

    public IndexOutputWriter(SequentialWriter out) {
        super(out.getPath(), out.getPath());
        this.out = out;
    }

    public void skipBytes(long length) throws IOException {
        this.out.skipBytes(length);
    }

    public File getFile() {
        return new File(this.out.getPath());
    }

    @Override
    public long getChecksum() throws IOException {
        return ((IndexFileUtils.ChecksummingWriter)this.out).getChecksum();
    }

    @Override
    public long getFilePointer() {
        return this.out.position();
    }

    @Override
    public void writeBytes(byte[] bytes, int offset, int len) throws IOException {
        this.out.write(bytes, offset, len);
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.out.writeByte(b);
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (logger.isTraceEnabled()) {
                logger.trace("Closing index output: {}", (Object)this);
            }
            this.out.close();
            this.closed = true;
        }
    }

    @Override
    public String toString() {
        Object checksum;
        try {
            checksum = String.valueOf(this.getChecksum());
        }
        catch (IOException e) {
            checksum = "unknown due to I/O error: " + e;
        }
        return MoreObjects.toStringHelper(this).add("path", this.out.getPath()).add("bytesWritten", this.getFilePointer()).add("crc", checksum).toString();
    }

    public SequentialWriter asSequentialWriter() {
        return this.out;
    }
}

