/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.analysis.hunspell.Hunspell;
import org.apache.lucene.analysis.hunspell.WordCase;

class Suggestion {
    final String raw;
    final String[] result;

    Suggestion(String raw, String misspelled, WordCase originalCase, Hunspell speller) {
        this.raw = raw;
        ArrayList<String> result = new ArrayList<String>();
        String adjusted = this.adjustSuggestionCase(raw, misspelled, originalCase);
        result.add(this.cleanOutput(speller, adjusted.contains(" ") || speller.spell(adjusted) ? adjusted : raw));
        if (originalCase == WordCase.UPPER && speller.dictionary.checkSharpS && raw.contains("\u00df")) {
            result.add(this.cleanOutput(speller, raw));
        }
        this.result = result.toArray(new String[0]);
    }

    private String adjustSuggestionCase(String candidate, String misspelled, WordCase originalCase) {
        if (originalCase == WordCase.UPPER) {
            return candidate.toUpperCase(Locale.ROOT);
        }
        if (Character.isUpperCase(misspelled.charAt(0))) {
            return Character.toUpperCase(candidate.charAt(0)) + candidate.substring(1);
        }
        return candidate;
    }

    private String cleanOutput(Hunspell speller, String s2) {
        if (speller.dictionary.oconv == null) {
            return s2;
        }
        StringBuilder sb = new StringBuilder(s2);
        speller.dictionary.oconv.applyMappings(sb);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Suggestion)) {
            return false;
        }
        Suggestion that = (Suggestion)o;
        return this.raw.equals(that.raw) && Arrays.equals(this.result, that.result);
    }

    public int hashCode() {
        return 31 * Objects.hash(this.raw) + Arrays.hashCode(this.result);
    }

    public String toString() {
        return this.raw;
    }
}

