/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.event;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MergeIterator<T>
implements Iterator<T> {
    private static final Comparator NATURAL = new NaturalComaprator();
    private final Iterator<T> a;
    private final Iterator<T> b;
    private final Comparator<T> comparator;
    private T peekA;
    private T peekB;

    public static <T> Iterator<T> merge(Iterator<T> a, Iterator<T> b) {
        return MergeIterator.merge(a, b, NATURAL);
    }

    public static <T> Iterator<T> merge(Iterator<T> a, Iterator<T> b, Comparator<T> cmp) {
        return new MergeIterator<T>(a, b, cmp);
    }

    public static <T> Iterable<T> merge(Iterable<T> a, Iterable<T> b) {
        return MergeIterator.merge(a, b, NATURAL);
    }

    public static <T> Iterable<T> merge(final Iterable<T> a, final Iterable<T> b, final Comparator<T> cmp) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return MergeIterator.merge(a.iterator(), b.iterator(), cmp);
            }
        };
    }

    public MergeIterator(Iterator<T> a, Iterator<T> b, Comparator<T> cmp) {
        this.a = a;
        this.b = b;
        this.comparator = cmp == null ? NATURAL : cmp;
        this.peekA = a.hasNext() ? this.next(a) : null;
        this.peekB = b.hasNext() ? this.next(b) : null;
    }

    private T next(Iterator<T> it) {
        T v = it.next();
        if (v == null) {
            throw new NullPointerException("null element is not allowed");
        }
        return v;
    }

    @Override
    public boolean hasNext() {
        return this.peekA != null || this.peekB != null;
    }

    @Override
    public T next() {
        T result;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.peekA == null && this.peekB != null) {
            result = this.peekB;
            this.peekB = this.b.hasNext() ? this.b.next() : null;
        } else if (this.peekB == null && this.peekA != null) {
            result = this.peekA;
            this.peekA = this.a.hasNext() ? this.a.next() : null;
        } else {
            int c = this.comparator.compare(this.peekA, this.peekB);
            if (c == 0) {
                result = this.peekA;
                this.peekA = this.a.hasNext() ? this.a.next() : null;
                this.peekB = this.b.hasNext() ? this.b.next() : null;
            } else if (c > 0) {
                result = this.peekB;
                this.peekB = this.b.hasNext() ? this.b.next() : null;
            } else {
                result = this.peekA;
                this.peekA = this.a.hasNext() ? this.a.next() : null;
            }
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class NaturalComaprator
    implements Comparator<Comparable<Object>> {
        private NaturalComaprator() {
        }

        @Override
        public int compare(Comparable<Object> o1, Comparable<Object> o2) {
            return o1.compareTo(o2);
        }
    }
}

