/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.metrics3.reporter.config;

import com.addthis.metrics.reporter.config.PredicateConfig;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricFilterTransformer {
    private static final Logger log = LoggerFactory.getLogger(MetricFilterTransformer.class);

    public static MetricFilter generateFilter(PredicateConfig predicate) {
        if (predicate == null) {
            return MetricFilter.ALL;
        }
        return new PredicateConfigFilter(predicate);
    }

    private static class PredicateConfigFilter
    implements MetricFilter {
        final PredicateConfig predicate;

        PredicateConfigFilter(PredicateConfig predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean matches(String name, Metric metric) {
            log.trace("Checking Metric name: {} {}", new Object[]{name, PredicateConfigFilter.unqualifyMetricName(name)});
            if (this.predicate.getUseQualifiedName()) {
                return this.predicate.allowString(name);
            }
            return this.predicate.allowString(PredicateConfigFilter.unqualifyMetricName(name));
        }

        private static String unqualifyMetricName(String name) {
            int location = name.lastIndexOf(46);
            if (location < 0) {
                return name;
            }
            return name.substring(location + 1);
        }
    }
}

