/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.sasl;

import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.celeborn.common.network.sasl.SaslUtils;
import org.apache.celeborn.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CelebornSaslClient {
    private static final Logger logger = LoggerFactory.getLogger(CelebornSaslClient.class);
    @GuardedBy(value="this")
    private SaslClient saslClient;

    public CelebornSaslClient(String saslMechanism, @Nullable Map<String, String> saslProps, @Nullable CallbackHandler authCallbackHandler) {
        Preconditions.checkNotNull(saslMechanism);
        SaslUtils.initializeSaslProviders();
        try {
            this.saslClient = Sasl.createSaslClient(new String[]{saslMechanism}, null, null, "default", saslProps, authCallbackHandler);
        }
        catch (SaslException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public synchronized byte[] firstToken() {
        if (this.saslClient != null && this.saslClient.hasInitialResponse()) {
            try {
                return this.saslClient.evaluateChallenge(SaslUtils.EMPTY_BYTE_ARRAY);
            }
            catch (SaslException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return SaslUtils.EMPTY_BYTE_ARRAY;
    }

    public synchronized boolean isComplete() {
        return this.saslClient != null && this.saslClient.isComplete();
    }

    public synchronized Object getNegotiatedProperty(String name) {
        return this.saslClient.getNegotiatedProperty(name);
    }

    public synchronized byte[] response(byte[] token) {
        try {
            return this.saslClient != null ? this.saslClient.evaluateChallenge(token) : SaslUtils.EMPTY_BYTE_ARRAY;
        }
        catch (SaslException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void dispose() {
        if (this.saslClient != null) {
            try {
                this.saslClient.dispose();
            }
            catch (SaslException saslException) {
            }
            finally {
                this.saslClient = null;
            }
        }
    }

    static class ClientCallbackHandler
    implements CallbackHandler {
        private final String id;
        private final String password;

        public ClientCallbackHandler(String id, String password) {
            this.id = Preconditions.checkNotNull(id, "id");
            this.password = Preconditions.checkNotNull(password, "password");
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    logger.trace("SASL client callback: setting username");
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(SaslUtils.encodeIdentifier(this.id));
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    logger.trace("SASL client callback: setting password");
                    PasswordCallback pc = (PasswordCallback)callback;
                    pc.setPassword(SaslUtils.encodePassword(this.password));
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    logger.trace("SASL client callback: setting realm");
                    RealmCallback rc = (RealmCallback)callback;
                    rc.setText(rc.getDefaultText());
                    continue;
                }
                if (callback instanceof RealmChoiceCallback) continue;
                throw new UnsupportedCallbackException(callback, "Unrecognized callback: " + callback);
            }
        }
    }
}

