/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.http.api.v1;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.Serializable;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.celeborn.common.util.Utils$;
import org.apache.celeborn.rest.v1.model.ContainerInfo;
import org.apache.celeborn.rest.v1.model.ThreadStack;
import org.apache.celeborn.rest.v1.model.ThreadStackResponse;
import org.apache.celeborn.server.common.HttpService;
import org.apache.celeborn.server.common.container.ContainerInfoProvider$;
import org.apache.celeborn.server.common.http.api.ApiRequestContext;
import org.apache.celeborn.server.common.http.api.v1.ConfResource;
import org.apache.celeborn.server.common.http.api.v1.LoggerResource;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@Path(value="/api/v1")
@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001\u0002\u0004\b\u0001aAQa\t\u0001\u0005\u0002\u0011BQa\n\u0001\u0005\u0002!BQ\u0001\u0012\u0001\u0005\u0002\u0015CQ!\u0014\u0001\u0005\u00029Cq!a\n\u0001\t\u0003\tICA\tBa&4\u0016GQ1tKJ+7o\\;sG\u0016T!\u0001C\u0005\u0002\u0005Y\f$B\u0001\u0006\f\u0003\r\t\u0007/\u001b\u0006\u0003\u00195\tA\u0001\u001b;ua*\u0011abD\u0001\u0007G>lWn\u001c8\u000b\u0005A\t\u0012AB:feZ,'O\u0003\u0002\u0013'\u0005A1-\u001a7fE>\u0014hN\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<7\u0001A\n\u0004\u0001ey\u0002C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g\r\u0005\u0002!C5\t\u0011\"\u0003\u0002#\u0013\t\t\u0012\t]5SKF,Xm\u001d;D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u0005)\u0003C\u0001\u0014\u0001\u001b\u00059\u0011\u0001B2p]\u001a,\u0012!\u000b\t\u0004UE\"dBA\u00160!\ta3$D\u0001.\u0015\tqs#\u0001\u0004=e>|GOP\u0005\u0003am\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001a4\u0005\u0015\u0019E.Y:t\u0015\t\u00014\u0004\u0005\u0002'k%\u0011ag\u0002\u0002\r\u0007>tgMU3t_V\u00148-\u001a\u0015\u0005\u0005a\u00125\t\u0005\u0002:\u00016\t!H\u0003\u0002<y\u0005\u0011!o\u001d\u0006\u0003{y\n!a^:\u000b\u0003}\nQA[1wCbL!!\u0011\u001e\u0003\tA\u000bG\u000f[\u0001\u0006m\u0006dW/Z\u0011\u0002O\u00051An\\4hKJ,\u0012A\u0012\t\u0004UE:\u0005C\u0001\u0014I\u0013\tIuA\u0001\bM_\u001e<WM\u001d*fg>,(oY3)\t\rA$iS\u0011\u0002\u0019\u00069An\\4hKJ\u001c\u0018A\u0003;ie\u0016\fG\rR;naR\tq\n\u0005\u0002Q-6\t\u0011K\u0003\u0002S'\u0006)Qn\u001c3fY*\u0011\u0001\u0002\u0016\u0006\u0003+F\tAA]3ti&\u0011q+\u0015\u0002\u0014)\"\u0014X-\u00193Ti\u0006\u001c7NU3ta>t7/\u001a\u0015\u0005\te\u0013E\f\u0005\u0002:5&\u00111L\u000f\u0002\t!J|G-^2fg2\nQ,I\u0001_\u0003A\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c80UN|g\u000e\u000b\u0002\u0005AB\u0011\u0011(Y\u0005\u0003Ej\u00121aR#UQ\u0019!A\r^;xqB\u0011QM]\u0007\u0002M*\u0011q\r[\u0001\ne\u0016\u001c\bo\u001c8tKNT!!\u001b6\u0002\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0003W2\f1a\\1t\u0015\tig.\u0001\u0002wg)\u0011q\u000e]\u0001\bg^\fwmZ3s\u0015\u0005\t\u0018AA5p\u0013\t\u0019hMA\u0006Ba&\u0014Vm\u001d9p]N,\u0017\u0001\u0004:fgB|gn]3D_\u0012,\u0017%\u0001<\u0002\u0007I\u0002\u0004'A\u0004d_:$XM\u001c;-\u0003e\\\u0003B_A\u0001;\u0006\r\u0011Q\u0001\t\u0003wzl\u0011\u0001 \u0006\u0003{\"\fQ!\\3eS\u0006L!a ?\u0003\u000f\r{g\u000e^3oi\u0006IQ.\u001a3jCRK\b/Z\u0001\u0007g\u000eDW-\\1,\r\u0005\u001d\u0011QBA\b!\rY\u0018\u0011B\u0005\u0004\u0003\u0017a(AB*dQ\u0016l\u0017-\u0001\bj[BdW-\\3oi\u0006$\u0018n\u001c8$\u0003=Cs\u0001BA\n\u00037\ti\u0002\u0005\u0003\u0002\u0016\u0005]Q\"\u00015\n\u0007\u0005e\u0001NA\u0005Pa\u0016\u0014\u0018\r^5p]\u0006YA-Z:de&\u0004H/[8oC\t\ty\"A\u000fMSN$\b\u0005\u001e5fA\r,(O]3oi\u0002\"\bN]3bI\u0002\"W/\u001c9/Q\u0015!\u0001HQA\u0012C\t\t)#\u0001\u00070i\"\u0014X-\u00193`IVl\u0007/A\u0007d_:$\u0018-\u001b8fe&sgm\u001c\u000b\u0003\u0003W\u00012\u0001UA\u0017\u0013\r\ty#\u0015\u0002\u000e\u0007>tG/Y5oKJLeNZ8)\u000b\u0015I&)a\r-\u0003uC#!\u00021)\u000f\u0015!G/^<\u0002:1\u0012\u00111H\u0016\tu\u0006\u0005Q,a\u0001\u0002>-2\u0011qAA\u0007\u0003\u007f\u0019#!a\u000b)\u000f\u0015\t\u0019\"a\u0007\u0002D\u0005\u0012\u0011QI\u0001\u0019\u0019&\u001cH\u000f\t;iK\u0002\u001awN\u001c;bS:,'\u000fI5oM>t\u0003&B\u00039\u0005\u0006%\u0013EAA&\u0003=y3m\u001c8uC&tWM]0j]\u001a|\u0007&\u0002\u00019\u0005\u0006=\u0013EAA)\u0003\u001dy\u0013\r]50mF\u0002")
public class ApiV1BaseResource
implements ApiRequestContext {
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    @Override
    public final HttpService httpService() {
        return ApiRequestContext.httpService$(this);
    }

    @Override
    public String normalizeParam(String param) {
        return ApiRequestContext.normalizeParam$(this, param);
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    @Path(value="conf")
    public Class<ConfResource> conf() {
        return ConfResource.class;
    }

    @Path(value="loggers")
    public Class<LoggerResource> logger() {
        return LoggerResource.class;
    }

    @Path(value="/thread_dump")
    @Operation(description="List the current thread dump.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=ThreadStackResponse.class))})
    @GET
    @Produces(value={"application/json"})
    public ThreadStackResponse threadDump() {
        return new ThreadStackResponse().threadStacks((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Utils$.MODULE$.getThreadDump().map((Function1 & Serializable & scala.Serializable)threadStack -> new ThreadStack().threadId(Predef$.MODULE$.long2Long(threadStack.threadId())).threadName(threadStack.threadName()).threadState(threadStack.threadState().toString()).stackTrace((List)JavaConverters$.MODULE$.seqAsJavaListConverter(threadStack.stackTrace().elems()).asJava()).blockedByThreadId((Long)threadStack.blockedByThreadId().getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).blockedByLock(threadStack.blockedByLock()).holdingLocks((List)JavaConverters$.MODULE$.seqAsJavaListConverter(threadStack.holdingLocks()).asJava()).synchronizers((List)JavaConverters$.MODULE$.seqAsJavaListConverter(threadStack.synchronizers()).asJava()).monitors((List)JavaConverters$.MODULE$.seqAsJavaListConverter(threadStack.monitors()).asJava()).lockName((String)threadStack.lockName().orNull(Predef$.MODULE$.$conforms())).lockOwnerName((String)threadStack.lockOwnerName().orNull(Predef$.MODULE$.$conforms())).suspended(Predef$.MODULE$.boolean2Boolean(threadStack.suspended())).inNative(Predef$.MODULE$.boolean2Boolean(threadStack.inNative())), Seq$.MODULE$.canBuildFrom())).asJava());
    }

    @Path(value="/container_info")
    @Operation(description="List the container info.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=ContainerInfo.class))})
    @GET
    @Produces(value={"application/json"})
    public ContainerInfo containerInfo() {
        return ContainerInfoProvider$.MODULE$.instantiate(this.httpService().conf()).getContainerInfo();
    }

    public ApiV1BaseResource() {
        ApiRequestContext.$init$(this);
    }
}

