/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.ThreadUtils;

public class Waiter {
    private static final AtomicInteger instanceCount = new AtomicInteger();
    private boolean active;
    private boolean valid;
    private long latency;
    private long lastPassivatedMillis;
    private long lastIdleTimeMillis;
    private long passivationCount;
    private long validationCount;
    private final int id = instanceCount.getAndIncrement();

    public static void sleepQuietly(long millis) {
        ThreadUtils.sleepQuietly((Duration)Duration.ofMillis(millis));
    }

    public Waiter(boolean active, boolean valid, long latency) {
        this.active = active;
        this.valid = valid;
        this.latency = latency;
        this.lastPassivatedMillis = System.currentTimeMillis();
    }

    public void doWait() {
        Waiter.sleepQuietly(this.latency);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Waiter)) {
            return false;
        }
        return obj.hashCode() == this.id;
    }

    public long getLastIdleTimeMillis() {
        return this.lastIdleTimeMillis;
    }

    public long getLastPassivatedMillis() {
        return this.lastPassivatedMillis;
    }

    public long getLatency() {
        return this.latency;
    }

    public long getPassivationCount() {
        return this.passivationCount;
    }

    public long getValidationCount() {
        return this.validationCount;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isValid() {
        ++this.validationCount;
        return this.valid;
    }

    public void setActive(boolean active) {
        boolean activeState = this.active;
        if (activeState == active) {
            return;
        }
        this.active = active;
        long currentTimeMillis = System.currentTimeMillis();
        if (active) {
            this.lastIdleTimeMillis = currentTimeMillis - this.lastPassivatedMillis;
        } else {
            this.lastPassivatedMillis = currentTimeMillis;
            ++this.passivationCount;
        }
    }

    public void setLatency(long latency) {
        this.latency = latency;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("ID = " + this.id + '\n');
        buff.append("valid = " + this.valid + '\n');
        buff.append("active = " + this.active + '\n');
        buff.append("lastPassivated = " + this.lastPassivatedMillis + '\n');
        buff.append("lastIdleTimeMs = " + this.lastIdleTimeMillis + '\n');
        buff.append("latency = " + this.latency + '\n');
        return buff.toString();
    }
}

