/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1CSINodeDriver;
import io.kubernetes.client.openapi.models.V1CSINodeDriverFluent;
import io.kubernetes.client.openapi.models.V1VolumeNodeResources;
import io.kubernetes.client.openapi.models.V1VolumeNodeResourcesBuilder;
import io.kubernetes.client.openapi.models.V1VolumeNodeResourcesFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1CSINodeDriverFluentImpl<A extends V1CSINodeDriverFluent<A>>
extends BaseFluent<A>
implements V1CSINodeDriverFluent<A> {
    private V1VolumeNodeResourcesBuilder allocatable;
    private String name;
    private String nodeID;
    private List<String> topologyKeys;

    public V1CSINodeDriverFluentImpl() {
    }

    public V1CSINodeDriverFluentImpl(V1CSINodeDriver instance) {
        if (instance != null) {
            this.withAllocatable(instance.getAllocatable());
            this.withName(instance.getName());
            this.withNodeID(instance.getNodeID());
            this.withTopologyKeys(instance.getTopologyKeys());
        }
    }

    @Override
    @Deprecated
    public V1VolumeNodeResources getAllocatable() {
        return this.allocatable != null ? this.allocatable.build() : null;
    }

    @Override
    public V1VolumeNodeResources buildAllocatable() {
        return this.allocatable != null ? this.allocatable.build() : null;
    }

    @Override
    public A withAllocatable(V1VolumeNodeResources allocatable) {
        this._visitables.get("allocatable").remove(this.allocatable);
        if (allocatable != null) {
            this.allocatable = new V1VolumeNodeResourcesBuilder(allocatable);
            this._visitables.get("allocatable").add(this.allocatable);
        } else {
            this.allocatable = null;
            this._visitables.get("allocatable").remove(this.allocatable);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllocatable() {
        return this.allocatable != null;
    }

    @Override
    public V1CSINodeDriverFluent.AllocatableNested<A> withNewAllocatable() {
        return new AllocatableNestedImpl();
    }

    @Override
    public V1CSINodeDriverFluent.AllocatableNested<A> withNewAllocatableLike(V1VolumeNodeResources item) {
        return new AllocatableNestedImpl(item);
    }

    @Override
    public V1CSINodeDriverFluent.AllocatableNested<A> editAllocatable() {
        return this.withNewAllocatableLike(this.getAllocatable());
    }

    @Override
    public V1CSINodeDriverFluent.AllocatableNested<A> editOrNewAllocatable() {
        return this.withNewAllocatableLike(this.getAllocatable() != null ? this.getAllocatable() : new V1VolumeNodeResourcesBuilder().build());
    }

    @Override
    public V1CSINodeDriverFluent.AllocatableNested<A> editOrNewAllocatableLike(V1VolumeNodeResources item) {
        return this.withNewAllocatableLike(this.getAllocatable() != null ? this.getAllocatable() : item);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    @Override
    public A withNodeID(String nodeID) {
        this.nodeID = nodeID;
        return (A)this;
    }

    @Override
    public Boolean hasNodeID() {
        return this.nodeID != null;
    }

    @Override
    public A addToTopologyKeys(int index, String item) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        this.topologyKeys.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTopologyKeys(int index, String item) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        this.topologyKeys.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTopologyKeys(String ... items) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        for (String item : items) {
            this.topologyKeys.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTopologyKeys(Collection<String> items) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        for (String item : items) {
            this.topologyKeys.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTopologyKeys(String ... items) {
        for (String item : items) {
            if (this.topologyKeys == null) continue;
            this.topologyKeys.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTopologyKeys(Collection<String> items) {
        for (String item : items) {
            if (this.topologyKeys == null) continue;
            this.topologyKeys.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getTopologyKeys() {
        return this.topologyKeys;
    }

    @Override
    public String getTopologyKey(int index) {
        return this.topologyKeys.get(index);
    }

    @Override
    public String getFirstTopologyKey() {
        return this.topologyKeys.get(0);
    }

    @Override
    public String getLastTopologyKey() {
        return this.topologyKeys.get(this.topologyKeys.size() - 1);
    }

    @Override
    public String getMatchingTopologyKey(Predicate<String> predicate) {
        for (String item : this.topologyKeys) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTopologyKey(Predicate<String> predicate) {
        for (String item : this.topologyKeys) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTopologyKeys(List<String> topologyKeys) {
        if (topologyKeys != null) {
            this.topologyKeys = new ArrayList<String>();
            for (String item : topologyKeys) {
                this.addToTopologyKeys(item);
            }
        } else {
            this.topologyKeys = null;
        }
        return (A)this;
    }

    @Override
    public A withTopologyKeys(String ... topologyKeys) {
        if (this.topologyKeys != null) {
            this.topologyKeys.clear();
            this._visitables.remove("topologyKeys");
        }
        if (topologyKeys != null) {
            for (String item : topologyKeys) {
                this.addToTopologyKeys(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTopologyKeys() {
        return this.topologyKeys != null && !this.topologyKeys.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1CSINodeDriverFluentImpl that = (V1CSINodeDriverFluentImpl)o;
        if (!Objects.equals(this.allocatable, that.allocatable)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.nodeID, that.nodeID)) {
            return false;
        }
        return Objects.equals(this.topologyKeys, that.topologyKeys);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allocatable, this.name, this.nodeID, this.topologyKeys, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allocatable != null) {
            sb.append("allocatable:");
            sb.append(this.allocatable + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.nodeID != null) {
            sb.append("nodeID:");
            sb.append(this.nodeID + ",");
        }
        if (this.topologyKeys != null && !this.topologyKeys.isEmpty()) {
            sb.append("topologyKeys:");
            sb.append(this.topologyKeys);
        }
        sb.append("}");
        return sb.toString();
    }

    class AllocatableNestedImpl<N>
    extends V1VolumeNodeResourcesFluentImpl<V1CSINodeDriverFluent.AllocatableNested<N>>
    implements V1CSINodeDriverFluent.AllocatableNested<N>,
    Nested<N> {
        V1VolumeNodeResourcesBuilder builder;

        AllocatableNestedImpl(V1VolumeNodeResources item) {
            this.builder = new V1VolumeNodeResourcesBuilder(this, item);
        }

        AllocatableNestedImpl() {
            this.builder = new V1VolumeNodeResourcesBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1CSINodeDriverFluentImpl.this.withAllocatable(this.builder.build());
        }

        @Override
        public N endAllocatable() {
            return this.and();
        }
    }
}

