/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ResourceClaimConsumerReference contains enough information to let you locate the consumer of a ResourceClaim. The user must be a resource in the same namespace as the ResourceClaim.")
public class V1alpha2ResourceClaimConsumerReference {
    public static final String SERIALIZED_NAME_API_GROUP = "apiGroup";
    @SerializedName(value="apiGroup")
    private String apiGroup;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_RESOURCE = "resource";
    @SerializedName(value="resource")
    private String resource;
    public static final String SERIALIZED_NAME_UID = "uid";
    @SerializedName(value="uid")
    private String uid;

    public V1alpha2ResourceClaimConsumerReference apiGroup(String apiGroup) {
        this.apiGroup = apiGroup;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.")
    public String getApiGroup() {
        return this.apiGroup;
    }

    public void setApiGroup(String apiGroup) {
        this.apiGroup = apiGroup;
    }

    public V1alpha2ResourceClaimConsumerReference name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name is the name of resource being referenced.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1alpha2ResourceClaimConsumerReference resource(String resource) {
        this.resource = resource;
        return this;
    }

    @ApiModelProperty(required=true, value="Resource is the type of resource being referenced, for example \"pods\".")
    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public V1alpha2ResourceClaimConsumerReference uid(String uid) {
        this.uid = uid;
        return this;
    }

    @ApiModelProperty(required=true, value="UID identifies exactly one incarnation of the resource.")
    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2ResourceClaimConsumerReference v1alpha2ResourceClaimConsumerReference = (V1alpha2ResourceClaimConsumerReference)o;
        return Objects.equals(this.apiGroup, v1alpha2ResourceClaimConsumerReference.apiGroup) && Objects.equals(this.name, v1alpha2ResourceClaimConsumerReference.name) && Objects.equals(this.resource, v1alpha2ResourceClaimConsumerReference.resource) && Objects.equals(this.uid, v1alpha2ResourceClaimConsumerReference.uid);
    }

    public int hashCode() {
        return Objects.hash(this.apiGroup, this.name, this.resource, this.uid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2ResourceClaimConsumerReference {\n");
        sb.append("    apiGroup: ").append(this.toIndentedString(this.apiGroup)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    uid: ").append(this.toIndentedString(this.uid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

