/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.variance;

import com.google.common.collect.Ordering;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.query.aggregation.variance.VarianceAggregatorCollector;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.apache.druid.segment.serde.ComplexMetricSerde;

public class VarianceSerde
extends ComplexMetricSerde {
    public static final String TYPE_NAME = "variance";
    private static final Ordering<VarianceAggregatorCollector> COMPARATOR = Ordering.from(VarianceAggregatorCollector.COMPARATOR).nullsFirst();

    public String getTypeName() {
        return TYPE_NAME;
    }

    public ComplexMetricExtractor getExtractor() {
        return new ComplexMetricExtractor(){

            public Class<VarianceAggregatorCollector> extractedClass() {
                return VarianceAggregatorCollector.class;
            }

            public VarianceAggregatorCollector extractValue(InputRow inputRow, String metricName) {
                Object rawValue = inputRow.getRaw(metricName);
                if (rawValue instanceof VarianceAggregatorCollector) {
                    return (VarianceAggregatorCollector)rawValue;
                }
                VarianceAggregatorCollector collector = new VarianceAggregatorCollector();
                List dimValues = inputRow.getDimension(metricName);
                if (dimValues != null && dimValues.size() > 0) {
                    for (String dimValue : dimValues) {
                        float value = Float.parseFloat(dimValue);
                        collector.add(value);
                    }
                }
                return collector;
            }
        };
    }

    public ObjectStrategy getObjectStrategy() {
        return new ObjectStrategy<VarianceAggregatorCollector>(){

            public Class<VarianceAggregatorCollector> getClazz() {
                return VarianceAggregatorCollector.class;
            }

            public VarianceAggregatorCollector fromByteBuffer(ByteBuffer buffer, int numBytes) {
                buffer.limit(buffer.position() + numBytes);
                return VarianceAggregatorCollector.from(buffer);
            }

            public byte[] toBytes(VarianceAggregatorCollector collector) {
                return collector == null ? new byte[]{} : collector.toByteArray();
            }

            public int compare(VarianceAggregatorCollector o1, VarianceAggregatorCollector o2) {
                return COMPARATOR.compare((Object)o1, (Object)o2);
            }

            public boolean readRetainsBufferReference() {
                return false;
            }
        };
    }
}

