/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kafka;

import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.druid.data.input.kafka.KafkaTopicPartition;
import org.apache.druid.indexing.seekablestream.SeekableStreamEndSequenceNumbers;
import org.apache.druid.indexing.seekablestream.SeekableStreamSequenceNumbers;
import org.apache.druid.utils.CollectionUtils;

@JsonTypeName(value="end")
public class KafkaSeekableStreamEndSequenceNumbers
extends SeekableStreamEndSequenceNumbers<KafkaTopicPartition, Long> {
    private final boolean isMultiTopicPartition;

    public KafkaSeekableStreamEndSequenceNumbers(String stream, String topic, Map<KafkaTopicPartition, Long> partitionSequenceNumberMap, Map<KafkaTopicPartition, Long> partitionOffsetMap) {
        super(stream, topic, partitionSequenceNumberMap, partitionOffsetMap);
        this.isMultiTopicPartition = !partitionSequenceNumberMap.isEmpty() && ((KafkaTopicPartition)partitionSequenceNumberMap.keySet().stream().findFirst().get()).isMultiTopicPartition();
    }

    public boolean isMultiTopicPartition() {
        return this.isMultiTopicPartition;
    }

    public SeekableStreamSequenceNumbers<KafkaTopicPartition, Long> plus(SeekableStreamSequenceNumbers<KafkaTopicPartition, Long> other) {
        Map<KafkaTopicPartition, Long> newMap;
        this.validateSequenceNumbersBaseType(other);
        KafkaSeekableStreamEndSequenceNumbers that = (KafkaSeekableStreamEndSequenceNumbers)other;
        if (!this.isMultiTopicPartition() && !that.isMultiTopicPartition()) {
            return super.plus(other);
        }
        String thisTopic = this.getStream();
        String thatTopic = that.getStream();
        if (!this.isMultiTopicPartition()) {
            newMap = new HashMap(this.getPartitionSequenceNumberMap());
            newMap.putAll(that.getPartitionSequenceNumberMap().entrySet().stream().filter(e -> {
                if (((KafkaTopicPartition)e.getKey()).topic().isPresent()) {
                    return ((KafkaTopicPartition)e.getKey()).topic().get().equals(thisTopic);
                }
                return thatTopic.equals(thisTopic);
            }).collect(Collectors.toMap(e -> new KafkaTopicPartition(false, thisTopic, ((KafkaTopicPartition)e.getKey()).partition()), Map.Entry::getValue)));
        } else {
            newMap = CollectionUtils.mapKeys((Map)this.getPartitionSequenceNumberMap(), k -> new KafkaTopicPartition(true, k.asTopicPartition(thisTopic).topic(), k.partition()));
            Pattern pattern = Pattern.compile(thisTopic);
            newMap.putAll(that.getPartitionSequenceNumberMap().entrySet().stream().filter(e -> {
                if (((KafkaTopicPartition)e.getKey()).topic().isPresent()) {
                    return pattern.matcher(((KafkaTopicPartition)e.getKey()).topic().get()).matches();
                }
                return pattern.matcher(thatTopic).matches();
            }).collect(Collectors.toMap(e -> new KafkaTopicPartition(true, ((KafkaTopicPartition)e.getKey()).asTopicPartition(thatTopic).topic(), ((KafkaTopicPartition)e.getKey()).partition()), Map.Entry::getValue)));
        }
        return new SeekableStreamEndSequenceNumbers(this.getStream(), newMap);
    }

    public SeekableStreamSequenceNumbers<KafkaTopicPartition, Long> minus(SeekableStreamSequenceNumbers<KafkaTopicPartition, Long> other) {
        this.validateSequenceNumbersBaseType(other);
        KafkaSeekableStreamEndSequenceNumbers otherEnd = (KafkaSeekableStreamEndSequenceNumbers)other;
        if (!this.isMultiTopicPartition() && !otherEnd.isMultiTopicPartition()) {
            return super.minus(other);
        }
        HashMap<KafkaTopicPartition, Long> newMap = new HashMap<KafkaTopicPartition, Long>();
        String thatTopic = otherEnd.getStream();
        for (Map.Entry entry : this.getPartitionSequenceNumberMap().entrySet()) {
            boolean otherContainsThisSingleTopic;
            String thisTopic = ((KafkaTopicPartition)entry.getKey()).asTopicPartition(this.getStream()).topic();
            boolean otherContainsThis = otherEnd.getPartitionSequenceNumberMap().containsKey(entry.getKey());
            boolean otherContainsThisMultiTopic = otherEnd.getPartitionSequenceNumberMap().containsKey(new KafkaTopicPartition(true, thisTopic, ((KafkaTopicPartition)entry.getKey()).partition()));
            boolean bl = otherContainsThisSingleTopic = thatTopic.equals(thisTopic) && otherEnd.getPartitionSequenceNumberMap().containsKey(new KafkaTopicPartition(false, null, ((KafkaTopicPartition)entry.getKey()).partition()));
            if (otherContainsThis || otherContainsThisMultiTopic || otherContainsThisSingleTopic) continue;
            newMap.put((KafkaTopicPartition)entry.getKey(), (Long)entry.getValue());
        }
        return new SeekableStreamEndSequenceNumbers(this.getStream(), newMap);
    }
}

