/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.histogram;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogram;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogramAggregatorFactory;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogramFoldingAggregator;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogramFoldingBufferAggregator;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogramFoldingVectorAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;

@JsonTypeName(value="approxHistogramFold")
public class ApproximateHistogramFoldingAggregatorFactory
extends ApproximateHistogramAggregatorFactory {
    @JsonCreator
    public ApproximateHistogramFoldingAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="resolution") Integer resolution, @JsonProperty(value="numBuckets") Integer numBuckets, @JsonProperty(value="lowerLimit") Float lowerLimit, @JsonProperty(value="upperLimit") Float upperLimit, @JsonProperty(value="finalizeAsBase64Binary") @Nullable Boolean finalizeAsBase64Binary) {
        super(name, fieldName, resolution, numBuckets, lowerLimit, upperLimit, finalizeAsBase64Binary);
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
        Class cls = selector.classOfObject();
        if (cls.equals(Object.class) || ApproximateHistogram.class.isAssignableFrom(cls)) {
            return new ApproximateHistogramFoldingAggregator((BaseObjectColumnValueSelector<ApproximateHistogram>)selector, this.resolution, this.lowerLimit, this.upperLimit);
        }
        throw new IAE("Incompatible type for metric[%s], expected a ApproximateHistogram, got a %s", new Object[]{this.fieldName, cls});
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
        Class cls = selector.classOfObject();
        if (cls.equals(Object.class) || ApproximateHistogram.class.isAssignableFrom(cls)) {
            return new ApproximateHistogramFoldingBufferAggregator((BaseObjectColumnValueSelector<ApproximateHistogram>)selector, this.resolution, this.lowerLimit, this.upperLimit);
        }
        throw new IAE("Incompatible type for metric[%s], expected a ApproximateHistogram, got a %s", new Object[]{this.fieldName, cls});
    }

    @Override
    public VectorAggregator factorizeVector(VectorColumnSelectorFactory metricVectorFactory) {
        VectorObjectSelector selector = metricVectorFactory.makeObjectSelector(this.fieldName);
        return new ApproximateHistogramFoldingVectorAggregator(selector, this.resolution, this.lowerLimit, this.upperLimit);
    }

    @Override
    public boolean canVectorize(ColumnInspector columnInspector) {
        ColumnCapabilities capabilities = columnInspector.getColumnCapabilities(this.fieldName);
        return capabilities != null && capabilities.is((TypeDescriptor)ValueType.COMPLEX);
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new ApproximateHistogramFoldingAggregatorFactory(this.name, this.name, this.resolution, this.numBuckets, Float.valueOf(this.lowerLimit), Float.valueOf(this.upperLimit), this.finalizeAsBase64Binary);
    }

    @Override
    public byte[] getCacheKey() {
        CacheKeyBuilder builder = new CacheKeyBuilder(19).appendString(this.fieldName).appendInt(this.resolution).appendInt(this.numBuckets).appendFloat(this.lowerLimit).appendFloat(this.upperLimit).appendBoolean(this.finalizeAsBase64Binary);
        return builder.build();
    }

    @Override
    public AggregatorFactory withName(String newName) {
        return new ApproximateHistogramFoldingAggregatorFactory(newName, this.getFieldName(), this.getResolution(), this.getNumBuckets(), Float.valueOf(this.getLowerLimit()), Float.valueOf(this.getUpperLimit()), this.finalizeAsBase64Binary);
    }

    @Override
    public String toString() {
        return "ApproximateHistogramFoldingAggregatorFactory{name='" + this.name + "', fieldName='" + this.fieldName + "', resolution=" + this.resolution + ", numBuckets=" + this.numBuckets + ", lowerLimit=" + this.lowerLimit + ", upperLimit=" + this.upperLimit + ", finalizeAsBase64Binary=" + this.finalizeAsBase64Binary + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ApproximateHistogramAggregatorFactory that = (ApproximateHistogramAggregatorFactory)((Object)o);
        return this.resolution == that.resolution && this.numBuckets == that.numBuckets && Float.compare(that.lowerLimit, this.lowerLimit) == 0 && Float.compare(that.upperLimit, this.upperLimit) == 0 && this.finalizeAsBase64Binary == that.finalizeAsBase64Binary && Objects.equals(this.name, that.name) && Objects.equals(this.fieldName, that.fieldName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.fieldName, this.resolution, this.numBuckets, Float.valueOf(this.lowerLimit), Float.valueOf(this.upperLimit), this.finalizeAsBase64Binary);
    }
}

