/*
 * Decompiled with CFR 0.152.
 */
package org.schemarepo;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.schemarepo.BaseRepository;
import org.schemarepo.Repository;
import org.schemarepo.Subject;
import org.schemarepo.SubjectConfig;

public abstract class DelegatingRepository
extends BaseRepository {
    protected final Repository repo;

    protected DelegatingRepository(Repository delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Delegate repository required");
        }
        this.repo = delegate;
    }

    @Override
    public void isValid() {
        if (this.repo instanceof BaseRepository) {
            ((BaseRepository)this.repo).isValid();
        }
    }

    @Override
    public Subject register(String subjectName, SubjectConfig config) {
        return this.repo.register(subjectName, config);
    }

    @Override
    public Subject lookup(String subjectName) {
        return this.repo.lookup(subjectName);
    }

    @Override
    public Iterable<Subject> subjects() {
        return this.repo.subjects();
    }

    @Override
    public void close() throws IOException {
        this.repo.close();
    }

    @Override
    protected Map<String, String> exposeConfiguration() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(super.exposeConfiguration());
        properties.put("DELEGATE", this.repo.toString());
        return properties;
    }
}

