/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.druid.indexer.RunnerTaskState;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.ImmutableWorkerInfo;
import org.apache.druid.indexing.overlord.TaskRunnerListener;
import org.apache.druid.indexing.overlord.TaskRunnerWorkItem;
import org.apache.druid.indexing.overlord.WorkerTaskRunner;
import org.apache.druid.indexing.overlord.autoscaling.ScalingStats;
import org.apache.druid.indexing.overlord.config.WorkerTaskRunnerConfig;
import org.apache.druid.indexing.worker.Worker;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.k8s.overlord.KubernetesTaskRunner;
import org.apache.druid.k8s.overlord.runnerstrategy.RunnerStrategy;
import org.apache.druid.tasklogs.TaskLogStreamer;

public class KubernetesAndWorkerTaskRunner
implements TaskLogStreamer,
WorkerTaskRunner {
    private final KubernetesTaskRunner kubernetesTaskRunner;
    private final WorkerTaskRunner workerTaskRunner;
    private final RunnerStrategy runnerStrategy;

    public KubernetesAndWorkerTaskRunner(KubernetesTaskRunner kubernetesTaskRunner, WorkerTaskRunner workerTaskRunner, RunnerStrategy runnerStrategy) {
        this.kubernetesTaskRunner = kubernetesTaskRunner;
        this.workerTaskRunner = workerTaskRunner;
        this.runnerStrategy = runnerStrategy;
    }

    public List<Pair<Task, ListenableFuture<TaskStatus>>> restore() {
        return Lists.newArrayList((Iterable)Iterables.concat(this.kubernetesTaskRunner.restore(), (Iterable)this.workerTaskRunner.restore()));
    }

    @LifecycleStart
    public void start() {
        this.kubernetesTaskRunner.start();
        this.workerTaskRunner.start();
    }

    public void registerListener(TaskRunnerListener listener, Executor executor) {
        this.kubernetesTaskRunner.registerListener(listener, executor);
        this.workerTaskRunner.registerListener(listener, executor);
    }

    public void unregisterListener(String listenerId) {
        this.kubernetesTaskRunner.unregisterListener(listenerId);
        this.workerTaskRunner.unregisterListener(listenerId);
    }

    public ListenableFuture<TaskStatus> run(Task task) {
        RunnerStrategy.RunnerType runnerType = this.runnerStrategy.getRunnerTypeForTask(task);
        if (RunnerStrategy.RunnerType.WORKER_RUNNER_TYPE.equals((Object)runnerType)) {
            return this.workerTaskRunner.run(task);
        }
        return this.kubernetesTaskRunner.run(task);
    }

    public void shutdown(String taskid, String reason) {
        this.workerTaskRunner.shutdown(taskid, reason);
        this.kubernetesTaskRunner.shutdown(taskid, reason);
    }

    @LifecycleStop
    public void stop() {
        this.kubernetesTaskRunner.stop();
        this.workerTaskRunner.stop();
    }

    public Collection<? extends TaskRunnerWorkItem> getRunningTasks() {
        return Lists.newArrayList((Iterable)Iterables.concat(this.kubernetesTaskRunner.getRunningTasks(), (Iterable)this.workerTaskRunner.getRunningTasks()));
    }

    public Collection<? extends TaskRunnerWorkItem> getPendingTasks() {
        return Lists.newArrayList((Iterable)Iterables.concat(this.kubernetesTaskRunner.getPendingTasks(), (Iterable)this.workerTaskRunner.getPendingTasks()));
    }

    public Collection<? extends TaskRunnerWorkItem> getKnownTasks() {
        return Lists.newArrayList((Iterable)Iterables.concat(this.kubernetesTaskRunner.getKnownTasks(), (Iterable)this.workerTaskRunner.getKnownTasks()));
    }

    public Optional<ScalingStats> getScalingStats() {
        return this.workerTaskRunner.getScalingStats();
    }

    public Map<String, Long> getTotalTaskSlotCount() {
        HashMap<String, Long> taskSlotCounts = new HashMap<String, Long>();
        taskSlotCounts.putAll(this.kubernetesTaskRunner.getTotalTaskSlotCount());
        taskSlotCounts.putAll(this.workerTaskRunner.getTotalTaskSlotCount());
        return taskSlotCounts;
    }

    public Map<String, Long> getIdleTaskSlotCount() {
        HashMap<String, Long> taskSlotCounts = new HashMap<String, Long>(this.workerTaskRunner.getIdleTaskSlotCount());
        this.kubernetesTaskRunner.getIdleTaskSlotCount().forEach((tier, count) -> taskSlotCounts.merge((String)tier, (Long)count, Long::sum));
        return taskSlotCounts;
    }

    public Map<String, Long> getUsedTaskSlotCount() {
        HashMap<String, Long> taskSlotCounts = new HashMap<String, Long>(this.workerTaskRunner.getUsedTaskSlotCount());
        this.kubernetesTaskRunner.getUsedTaskSlotCount().forEach((tier, count) -> taskSlotCounts.merge((String)tier, (Long)count, Long::sum));
        return taskSlotCounts;
    }

    public Map<String, Long> getLazyTaskSlotCount() {
        HashMap<String, Long> taskSlotCounts = new HashMap<String, Long>(this.workerTaskRunner.getLazyTaskSlotCount());
        this.kubernetesTaskRunner.getLazyTaskSlotCount().forEach((tier, count) -> taskSlotCounts.merge((String)tier, (Long)count, Long::sum));
        return taskSlotCounts;
    }

    public Map<String, Long> getBlacklistedTaskSlotCount() {
        HashMap<String, Long> taskSlotCounts = new HashMap<String, Long>(this.workerTaskRunner.getBlacklistedTaskSlotCount());
        this.kubernetesTaskRunner.getBlacklistedTaskSlotCount().forEach((tier, count) -> taskSlotCounts.merge((String)tier, (Long)count, Long::sum));
        return taskSlotCounts;
    }

    public Collection<ImmutableWorkerInfo> getWorkers() {
        return this.workerTaskRunner.getWorkers();
    }

    public Collection<Worker> getLazyWorkers() {
        return this.workerTaskRunner.getLazyWorkers();
    }

    public Collection<Worker> markWorkersLazy(Predicate<ImmutableWorkerInfo> isLazyWorker, int maxWorkers) {
        return this.workerTaskRunner.markWorkersLazy(isLazyWorker, maxWorkers);
    }

    public WorkerTaskRunnerConfig getConfig() {
        return this.workerTaskRunner.getConfig();
    }

    public Collection<Task> getPendingTaskPayloads() {
        return this.workerTaskRunner.getPendingTaskPayloads();
    }

    public Optional<InputStream> streamTaskLog(String taskid, long offset) throws IOException {
        Optional<InputStream> kubernetesTaskLog = this.kubernetesTaskRunner.streamTaskLog(taskid, offset);
        if (kubernetesTaskLog.isPresent()) {
            return kubernetesTaskLog;
        }
        if (this.workerTaskRunner instanceof TaskLogStreamer) {
            return ((TaskLogStreamer)this.workerTaskRunner).streamTaskLog(taskid, offset);
        }
        return Optional.absent();
    }

    public TaskLocation getTaskLocation(String taskId) {
        TaskLocation taskLocation = this.kubernetesTaskRunner.getTaskLocation(taskId);
        if (taskLocation == null || taskLocation.equals((Object)TaskLocation.unknown())) {
            return this.workerTaskRunner.getTaskLocation(taskId);
        }
        return taskLocation;
    }

    @Nullable
    public RunnerTaskState getRunnerTaskState(String taskId) {
        RunnerTaskState runnerTaskState = this.kubernetesTaskRunner.getRunnerTaskState(taskId);
        if (runnerTaskState == null) {
            return this.workerTaskRunner.getRunnerTaskState(taskId);
        }
        return runnerTaskState;
    }

    public int getTotalCapacity() {
        int k8sCapacity = this.kubernetesTaskRunner.getTotalCapacity();
        int workerCapacity = this.workerTaskRunner.getTotalCapacity();
        if (k8sCapacity == -1 && workerCapacity == -1) {
            return -1;
        }
        return Math.max(0, k8sCapacity) + Math.max(0, workerCapacity);
    }

    public int getMaximumCapacityWithAutoscale() {
        return this.workerTaskRunner.getMaximumCapacityWithAutoscale() + this.kubernetesTaskRunner.getMaximumCapacityWithAutoscale();
    }

    public int getUsedCapacity() {
        int k8sCapacity = this.kubernetesTaskRunner.getUsedCapacity();
        int workerCapacity = this.workerTaskRunner.getUsedCapacity();
        if (k8sCapacity == -1 && workerCapacity == -1) {
            return -1;
        }
        return Math.max(0, k8sCapacity) + Math.max(0, workerCapacity);
    }

    public void updateStatus(Task task, TaskStatus status) {
        this.kubernetesTaskRunner.updateStatus(task, status);
    }

    public void updateLocation(Task task, TaskLocation location) {
        this.kubernetesTaskRunner.updateLocation(task, location);
    }
}

