/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.DescribeDBRecommendationsRequest;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class DescribeDBRecommendationsRequestMarshaller
implements Marshaller<Request<DescribeDBRecommendationsRequest>, DescribeDBRecommendationsRequest> {
    public Request<DescribeDBRecommendationsRequest> marshall(DescribeDBRecommendationsRequest describeDBRecommendationsRequest) {
        if (describeDBRecommendationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDBRecommendationsRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeDBRecommendations");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDBRecommendationsRequest.getLastUpdatedAfter() != null) {
            request.addParameter("LastUpdatedAfter", StringUtils.fromDate((Date)describeDBRecommendationsRequest.getLastUpdatedAfter()));
        }
        if (describeDBRecommendationsRequest.getLastUpdatedBefore() != null) {
            request.addParameter("LastUpdatedBefore", StringUtils.fromDate((Date)describeDBRecommendationsRequest.getLastUpdatedBefore()));
        }
        if (describeDBRecommendationsRequest.getLocale() != null) {
            request.addParameter("Locale", StringUtils.fromString((String)describeDBRecommendationsRequest.getLocale()));
        }
        if (!describeDBRecommendationsRequest.getFilters().isEmpty() || !((SdkInternalList)describeDBRecommendationsRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeDBRecommendationsRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue != null) {
                    if (filtersListValue.getName() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                    }
                    if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                        SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                        int valuesListIndex = 1;
                        for (String valuesListValue : valuesList) {
                            if (valuesListValue != null) {
                                request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                            }
                            ++valuesListIndex;
                        }
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeDBRecommendationsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeDBRecommendationsRequest.getMaxRecords()));
        }
        if (describeDBRecommendationsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeDBRecommendationsRequest.getMarker()));
        }
        return request;
    }
}

