/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.importhandler.users;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.Count;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandler;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandlerUtils;
import org.apache.fineract.infrastructure.core.serialization.GoogleGsonSerializerHelper;
import org.apache.fineract.useradministration.data.AppUserData;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserImportHandler
implements ImportHandler {
    private static final Logger LOG = LoggerFactory.getLogger(UserImportHandler.class);
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @Autowired
    public UserImportHandler(PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }

    public Count process(Workbook workbook, String locale, String dateFormat) {
        ArrayList statuses = new ArrayList();
        List users = this.readExcelFile(workbook, statuses);
        return this.importEntity(workbook, users);
    }

    private List<AppUserData> readExcelFile(Workbook workbook, List<String> statuses) {
        ArrayList<AppUserData> users = new ArrayList<AppUserData>();
        Sheet usersSheet = workbook.getSheet("Users");
        Integer noOfEntries = ImportHandlerUtils.getNumberOfRows((Sheet)usersSheet, (int)0);
        for (int rowIndex = 1; rowIndex <= noOfEntries; ++rowIndex) {
            Row row = usersSheet.getRow(rowIndex);
            if (!ImportHandlerUtils.isNotImported((Row)row, (int)8)) continue;
            users.add(this.readUsers(workbook, row, statuses));
        }
        return users;
    }

    private AppUserData readUsers(Workbook workbook, Row row, List<String> statuses) {
        String roleName;
        String officeName = ImportHandlerUtils.readAsString((int)0, (Row)row);
        Long officeId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Offices"), (String)officeName);
        String staffName = ImportHandlerUtils.readAsString((int)1, (Row)row);
        Long staffId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Staff"), (String)staffName);
        String userName = ImportHandlerUtils.readAsString((int)2, (Row)row);
        String firstName = ImportHandlerUtils.readAsString((int)3, (Row)row);
        String lastName = ImportHandlerUtils.readAsString((int)4, (Row)row);
        String email = ImportHandlerUtils.readAsString((int)5, (Row)row);
        Boolean autoGenPw = ImportHandlerUtils.readAsBoolean((int)6, (Row)row);
        Boolean overridepw = ImportHandlerUtils.readAsBoolean((int)7, (Row)row);
        String status = ImportHandlerUtils.readAsString((int)8, (Row)row);
        statuses.add(status);
        ArrayList<Long> rolesIds = new ArrayList<Long>();
        for (int cellNo = 9; cellNo < 14 && (roleName = ImportHandlerUtils.readAsString((int)cellNo, (Row)row)) != null; ++cellNo) {
            Long roleId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Roles"), (String)roleName);
            if (rolesIds.contains(roleId)) continue;
            rolesIds.add(roleId);
        }
        return AppUserData.importInstance((Long)officeId, (Long)staffId, (String)userName, (String)firstName, (String)lastName, (String)email, (Boolean)autoGenPw, (Boolean)overridepw, rolesIds, (Integer)row.getRowNum());
    }

    private Count importEntity(Workbook workbook, List<AppUserData> users) {
        Sheet userSheet = workbook.getSheet("Users");
        int successCount = 0;
        int errorCount = 0;
        GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
        for (AppUserData user : users) {
            try {
                JsonObject userJsonob = gsonBuilder.create().toJsonTree((Object)user).getAsJsonObject();
                String payload = userJsonob.toString();
                CommandWrapper commandRequest = new CommandWrapperBuilder().createUser().withJson(payload).build();
                this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
                ++successCount;
                Cell statusCell = userSheet.getRow(user.getRowIndex().intValue()).createCell(8);
                statusCell.setCellValue("Imported");
                statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)workbook, (IndexedColors)IndexedColors.LIGHT_GREEN));
            }
            catch (RuntimeException ex) {
                ++errorCount;
                LOG.error("Problem occurred in importEntity function", (Throwable)ex);
                String errorMessage = ImportHandlerUtils.getErrorMessage((RuntimeException)ex);
                ImportHandlerUtils.writeErrorMessage((Sheet)userSheet, (Integer)user.getRowIndex(), (String)errorMessage, (int)8);
            }
        }
        userSheet.setColumnWidth(8, 4000);
        ImportHandlerUtils.writeString((int)8, (Row)userSheet.getRow(0), (String)"Status");
        return Count.instance((Integer)successCount, (Integer)errorCount);
    }
}

