/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service;

import java.util.HashMap;
import lombok.Generated;
import org.apache.fineract.infrastructure.businessdate.service.BusinessDateReadPlatformService;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.jobs.service.SchedularWritePlatformService;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SchedulerVetoer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchedulerVetoer.class);
    private final SchedularWritePlatformService schedularService;
    private final BusinessDateReadPlatformService businessDateReadPlatformService;

    @Transactional(isolation=Isolation.READ_COMMITTED)
    public boolean veto(Trigger trigger, JobExecutionContext context) {
        boolean vetoJob;
        String tenantIdentifier = trigger.getJobDataMap().getString("tenantIdentifier");
        HashMap businessDates = this.businessDateReadPlatformService.getBusinessDates();
        ThreadLocalContextUtil.setBusinessDates((HashMap)businessDates);
        JobKey key = trigger.getJobKey();
        String jobKey = key.getName() + " _ " + key.getGroup();
        String triggerType = "cron";
        if (context.getMergedJobDataMap().containsKey((Object)"TRIGGER_TYPE_REFERENCE")) {
            triggerType = context.getMergedJobDataMap().getString("TRIGGER_TYPE_REFERENCE");
        }
        if (vetoJob = this.schedularService.processJobDetailForExecution(jobKey, triggerType)) {
            log.warn("vetoJobExecution() WILL veto the execution (returning vetoJob == true; the job's execute method will NOT be called); tenant={}, jobKey={}, triggerType={}, trigger={}, context={}", new Object[]{tenantIdentifier, jobKey, triggerType, trigger, context});
        }
        return vetoJob;
    }

    @Generated
    public SchedulerVetoer(SchedularWritePlatformService schedularService, BusinessDateReadPlatformService businessDateReadPlatformService) {
        this.schedularService = schedularService;
        this.businessDateReadPlatformService = businessDateReadPlatformService;
    }
}

