/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.filter;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.fineract.infrastructure.businessdate.service.BusinessDateReadPlatformService;
import org.apache.fineract.infrastructure.cache.domain.CacheType;
import org.apache.fineract.infrastructure.cache.service.CacheWritePlatformService;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.domain.FineractPlatformTenant;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.security.data.PlatformRequestLog;
import org.apache.fineract.infrastructure.security.exception.InvalidTenantIdentifierException;
import org.apache.fineract.infrastructure.security.service.AuthTenantDetailsService;
import org.apache.fineract.notification.service.UserNotificationService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class TenantAwareBasicAuthenticationFilter
extends BasicAuthenticationFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantAwareBasicAuthenticationFilter.class);
    private static boolean FIRST_REQUEST_PROCESSED = false;
    private static final String TENANT_ID_REQUEST_HEADER = "Fineract-Platform-TenantId";
    private static final boolean EXCEPTION_IF_HEADER_MISSING = true;
    private final ToApiJsonSerializer<PlatformRequestLog> toApiJsonSerializer;
    private final ConfigurationDomainService configurationDomainService;
    private final CacheWritePlatformService cacheWritePlatformService;
    private final UserNotificationService userNotificationService;
    private final AuthTenantDetailsService basicAuthTenantDetailsService;
    private final BusinessDateReadPlatformService businessDateReadPlatformService;
    private RequestMatcher requestMatcher = AnyRequestMatcher.INSTANCE;

    public TenantAwareBasicAuthenticationFilter(AuthenticationManager authenticationManager, AuthenticationEntryPoint authenticationEntryPoint, ToApiJsonSerializer<PlatformRequestLog> toApiJsonSerializer, ConfigurationDomainService configurationDomainService, CacheWritePlatformService cacheWritePlatformService, UserNotificationService userNotificationService, AuthTenantDetailsService basicAuthTenantDetailsService, BusinessDateReadPlatformService businessDateReadPlatformService) {
        super(authenticationManager, authenticationEntryPoint);
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.configurationDomainService = configurationDomainService;
        this.cacheWritePlatformService = cacheWritePlatformService;
        this.userNotificationService = userNotificationService;
        this.basicAuthTenantDetailsService = basicAuthTenantDetailsService;
        this.businessDateReadPlatformService = businessDateReadPlatformService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        StopWatch task = new StopWatch();
        task.start();
        try {
            ThreadLocalContextUtil.reset();
            if ("OPTIONS".equalsIgnoreCase(request.getMethod())) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                if (this.requestMatcher.matches(request)) {
                    String tenantIdentifier = request.getHeader(TENANT_ID_REQUEST_HEADER);
                    if (StringUtils.isBlank((CharSequence)tenantIdentifier)) {
                        tenantIdentifier = request.getParameter("tenantIdentifier");
                    }
                    if (tenantIdentifier == null) {
                        throw new InvalidTenantIdentifierException("No tenant identifier found: Add request header of 'Fineract-Platform-TenantId' or add the parameter 'tenantIdentifier' to query string of request URL.");
                    }
                    String pathInfo = request.getRequestURI();
                    boolean isReportRequest = false;
                    if (pathInfo != null && pathInfo.contains("report")) {
                        isReportRequest = true;
                    }
                    FineractPlatformTenant tenant = this.basicAuthTenantDetailsService.loadTenantById(tenantIdentifier, isReportRequest);
                    ThreadLocalContextUtil.setTenant((FineractPlatformTenant)tenant);
                    HashMap businessDates = this.businessDateReadPlatformService.getBusinessDates();
                    ThreadLocalContextUtil.setBusinessDates((HashMap)businessDates);
                    String authToken = request.getHeader("Authorization");
                    if (authToken != null && authToken.startsWith("Basic ")) {
                        ThreadLocalContextUtil.setAuthToken((String)authToken.replaceFirst("Basic ", ""));
                    }
                    if (!FIRST_REQUEST_PROCESSED) {
                        String baseUrl = request.getRequestURL().toString().replace(request.getPathInfo(), "/");
                        System.setProperty("baseUrl", baseUrl);
                        boolean ehcacheEnabled = this.configurationDomainService.isEhcacheEnabled();
                        if (ehcacheEnabled) {
                            this.cacheWritePlatformService.switchToCache(CacheType.SINGLE_NODE);
                        } else {
                            this.cacheWritePlatformService.switchToCache(CacheType.NO_CACHE);
                        }
                        FIRST_REQUEST_PROCESSED = true;
                    }
                }
                super.doFilterInternal(request, response, filterChain);
            }
        }
        catch (InvalidTenantIdentifierException e) {
            SecurityContextHolder.getContext().setAuthentication(null);
            response.addHeader("WWW-Authenticate", "Basic realm=\"Fineract Platform API\"");
            response.sendError(400, e.getMessage());
        }
        finally {
            ThreadLocalContextUtil.reset();
            task.stop();
            PlatformRequestLog msg = PlatformRequestLog.from((StopWatch)task, (HttpServletRequest)request);
            log.debug("{}", (Object)this.toApiJsonSerializer.serialize((Object)msg));
        }
    }

    protected void onSuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
        boolean notAllowed;
        super.onSuccessfulAuthentication(request, response, authResult);
        AppUser user = (AppUser)authResult.getPrincipal();
        if (this.userNotificationService.hasUnreadUserNotifications((Long)user.getId())) {
            response.addHeader("X-Notification-Refresh", "true");
        } else {
            response.addHeader("X-Notification-Refresh", "false");
        }
        String pathURL = request.getRequestURI();
        boolean isSelfServiceRequest = pathURL != null && pathURL.contains("/self/");
        boolean bl = notAllowed = isSelfServiceRequest && !user.isSelfServiceUser() || !isSelfServiceRequest && user.isSelfServiceUser();
        if (notAllowed) {
            throw new BadCredentialsException("User not authorised to use the requested resource.");
        }
    }

    @Generated
    public void setRequestMatcher(RequestMatcher requestMatcher) {
        this.requestMatcher = requestMatcher;
    }
}

