/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.service;

import java.math.BigDecimal;
import java.math.MathContext;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.domain.LocalDateInterval;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.infrastructure.jobs.exception.JobExecutionException;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.monetary.domain.MoneyHelper;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.portfolio.savings.SavingsCompoundingInterestPeriodType;
import org.apache.fineract.portfolio.savings.SavingsInterestCalculationDaysInYearType;
import org.apache.fineract.portfolio.savings.SavingsInterestCalculationType;
import org.apache.fineract.portfolio.savings.SavingsPostingInterestPeriodType;
import org.apache.fineract.portfolio.savings.data.SavingsAccrualData;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountAssembler;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountRepositoryWrapper;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransaction;
import org.apache.fineract.portfolio.savings.domain.SavingsHelper;
import org.apache.fineract.portfolio.savings.domain.interest.CompoundInterestValues;
import org.apache.fineract.portfolio.savings.domain.interest.PostingPeriod;
import org.apache.fineract.portfolio.savings.service.SavingsAccountDomainService;
import org.apache.fineract.portfolio.savings.service.SavingsAccountReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsAccrualWritePlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SavingsAccrualWritePlatformServiceImpl
implements SavingsAccrualWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SavingsAccrualWritePlatformServiceImpl.class);
    private final SavingsAccountReadPlatformService savingsAccountReadPlatformService;
    private final SavingsAccountAssembler savingsAccountAssembler;
    private final SavingsAccountRepositoryWrapper savingsAccountRepository;
    private final SavingsHelper savingsHelper;
    private final ConfigurationDomainService configurationDomainService;
    private final SavingsAccountDomainService savingsAccountDomainService;

    @Transactional
    public void addAccrualEntries(LocalDate tillDate) throws JobExecutionException {
        List savingsAccrualData = this.savingsAccountReadPlatformService.retrievePeriodicAccrualData(tillDate, null);
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        MathContext mc = MoneyHelper.getMathContext();
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (SavingsAccrualData savingsAccrual : savingsAccrualData) {
            try {
                if (savingsAccrual.getDepositType().isSavingsDeposit() && savingsAccrual.getIsAllowOverdraft().booleanValue() && !savingsAccrual.getIsTypeInterestReceivable().booleanValue()) continue;
                SavingsAccount savingsAccount = this.savingsAccountAssembler.assembleFrom(savingsAccrual.getId(), false);
                LocalDate fromDate = savingsAccrual.getAccruedTill();
                if (fromDate == null) {
                    fromDate = savingsAccount.getActivationDate();
                }
                log.debug("Processing savings account {} from date {} till date {}", new Object[]{savingsAccrual.getAccountNo(), fromDate, tillDate});
                this.addAccrualTransactions(savingsAccount, fromDate, tillDate, financialYearBeginningMonth, isSavingsInterestPostingAtCurrentPeriodEnd, mc, null);
            }
            catch (Exception e) {
                log.error("Failed to add accrual transaction for savings {} : {}", (Object)savingsAccrual.getAccountNo(), (Object)e.getMessage());
                errors.add(e.getCause());
            }
        }
        if (!errors.isEmpty()) {
            throw new JobExecutionException(errors);
        }
    }

    private void addAccrualTransactions(SavingsAccount savingsAccount, LocalDate fromDate, LocalDate tillDate, Integer financialYearBeginningMonth, boolean isSavingsInterestPostingAtCurrentPeriodEnd, MathContext mc, Function<LocalDate, String> refNoProvider) {
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        existingTransactionIds.addAll(savingsAccount.findExistingTransactionIds());
        existingReversedTransactionIds.addAll(savingsAccount.findExistingReversedTransactionIds());
        List postedAsOnTransactionDates = savingsAccount.getManualPostingDates();
        SavingsPostingInterestPeriodType postingPeriodType = SavingsPostingInterestPeriodType.fromInt((Integer)savingsAccount.getInterestCalculationType());
        SavingsCompoundingInterestPeriodType compoundingPeriodType = SavingsCompoundingInterestPeriodType.fromInt((Integer)savingsAccount.getInterestPostingPeriodType());
        SavingsInterestCalculationDaysInYearType daysInYearType = SavingsInterestCalculationDaysInYearType.fromInt((Integer)savingsAccount.getInterestCalculationDaysInYearType());
        List postingPeriodIntervals = this.savingsHelper.determineInterestPostingPeriods(fromDate, tillDate, postingPeriodType, financialYearBeginningMonth, postedAsOnTransactionDates);
        ArrayList<PostingPeriod> allPostingPeriods = new ArrayList<PostingPeriod>();
        MonetaryCurrency currency = savingsAccount.getCurrency();
        Money periodStartingBalance = Money.zero((MonetaryCurrency)currency);
        SavingsInterestCalculationType interestCalculationType = SavingsInterestCalculationType.fromInt((Integer)savingsAccount.getInterestCalculationType());
        BigDecimal interestRateAsFraction = savingsAccount.getEffectiveInterestRateAsFractionAccrual(mc, tillDate);
        Collection interestPostTransactions = this.savingsHelper.fetchPostInterestTransactionIds((Long)savingsAccount.getId());
        boolean isInterestTransfer = false;
        Money minBalanceForInterestCalculation = Money.of((MonetaryCurrency)currency, (BigDecimal)savingsAccount.getMinBalanceForInterestCalculation());
        List savingsAccountTransactionDetailsForPostingPeriodList = savingsAccount.toSavingsAccountTransactionDetailsForPostingPeriodList();
        for (LocalDateInterval periodInterval : postingPeriodIntervals) {
            if (DateUtils.isDateInTheFuture((LocalDate)periodInterval.endDate())) continue;
            boolean isUserPosting = postedAsOnTransactionDates.contains(periodInterval.endDate());
            PostingPeriod postingPeriod = PostingPeriod.createFrom((LocalDateInterval)periodInterval, (Money)periodStartingBalance, (List)savingsAccountTransactionDetailsForPostingPeriodList, (MonetaryCurrency)currency, (SavingsCompoundingInterestPeriodType)compoundingPeriodType, (SavingsInterestCalculationType)interestCalculationType, (BigDecimal)interestRateAsFraction, (long)daysInYearType.getValue().intValue(), (LocalDate)tillDate, (Collection)interestPostTransactions, (boolean)isInterestTransfer, (Money)minBalanceForInterestCalculation, (boolean)isSavingsInterestPostingAtCurrentPeriodEnd, (boolean)isUserPosting, (Integer)financialYearBeginningMonth);
            postingPeriod.setOverdraftInterestRateAsFraction(savingsAccount.getNominalAnnualInterestRateOverdraft().divide(BigDecimal.valueOf(100L), mc));
            periodStartingBalance = postingPeriod.closingBalance();
            allPostingPeriods.add(postingPeriod);
        }
        BigDecimal compoundedInterest = BigDecimal.ZERO;
        BigDecimal unCompoundedInterest = BigDecimal.ZERO;
        CompoundInterestValues compoundInterestValues = new CompoundInterestValues(compoundedInterest, unCompoundedInterest);
        List<LocalDate> accrualTransactionDates = savingsAccount.retrieveOrderedAccrualTransactions().stream().map(transaction -> transaction.getTransactionDate()).toList();
        List<LocalDate> reversedAccrualTransactionDates = savingsAccount.retrieveOrderedAccrualTransactions().stream().filter(transaction -> transaction.isReversed()).map(transaction -> transaction.getTransactionDate()).toList();
        LocalDate accruedTillDate = fromDate;
        for (PostingPeriod period : allPostingPeriods) {
            LocalDate valueDate = period.getPeriodInterval().endDate();
            List<LocalDate> matchingAccrualDates = accrualTransactionDates.stream().filter(accrualDate -> accrualDate.equals(valueDate)).toList();
            List<LocalDate> matchingAccrualReverseDates = reversedAccrualTransactionDates.stream().filter(accrualDate -> accrualDate.equals(valueDate)).toList();
            period.calculateInterest(compoundInterestValues);
            LocalDate endDate = period.getPeriodInterval().endDate();
            if (accrualTransactionDates.contains(period.getPeriodInterval().endDate()) && (matchingAccrualReverseDates.isEmpty() || matchingAccrualDates.size() != matchingAccrualReverseDates.size())) continue;
            String refNo = refNoProvider != null ? refNoProvider.apply(endDate) : null;
            SavingsAccountTransaction savingsAccountTransaction = SavingsAccountTransaction.accrual((SavingsAccount)savingsAccount, (Office)savingsAccount.office(), (LocalDate)period.getPeriodInterval().endDate(), (Money)period.getInterestEarned().abs(), (boolean)false, (String)refNo);
            savingsAccountTransaction.setRunningBalance(period.getClosingBalance());
            savingsAccountTransaction.setOverdraftAmount(period.getInterestEarned());
            if (MathUtil.isZero((BigDecimal)savingsAccountTransaction.getAmount())) continue;
            savingsAccount.addTransaction(savingsAccountTransaction);
        }
        savingsAccount.setAccruedTillDate(accruedTillDate);
        this.savingsAccountRepository.saveAndFlush(savingsAccount);
        this.savingsAccountDomainService.postJournalEntries(savingsAccount, existingTransactionIds, existingReversedTransactionIds, false);
    }

    @Generated
    public SavingsAccrualWritePlatformServiceImpl(SavingsAccountReadPlatformService savingsAccountReadPlatformService, SavingsAccountAssembler savingsAccountAssembler, SavingsAccountRepositoryWrapper savingsAccountRepository, SavingsHelper savingsHelper, ConfigurationDomainService configurationDomainService, SavingsAccountDomainService savingsAccountDomainService) {
        this.savingsAccountReadPlatformService = savingsAccountReadPlatformService;
        this.savingsAccountAssembler = savingsAccountAssembler;
        this.savingsAccountRepository = savingsAccountRepository;
        this.savingsHelper = savingsHelper;
        this.configurationDomainService = configurationDomainService;
        this.savingsAccountDomainService = savingsAccountDomainService;
    }
}

