/*
 * Decompiled with CFR 0.152.
 */
package grails.init;

import grails.init.GrailsReleaseType;
import grails.init.GrailsVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RootMetadataHandler
extends DefaultHandler {
    private Set<GrailsReleaseType> allowedReleaseTypes;
    private List<GrailsVersion> versions = new ArrayList<GrailsVersion>();
    private boolean foundVersions;
    private boolean foundVersion;

    public RootMetadataHandler(Set<GrailsReleaseType> allowedReleaseTypes) {
        this.allowedReleaseTypes = allowedReleaseTypes;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equalsIgnoreCase("VERSIONS")) {
            this.foundVersions = true;
        } else if (this.foundVersions && qName.equalsIgnoreCase("VERSION")) {
            this.foundVersion = true;
        } else {
            this.foundVersions = false;
            this.foundVersion = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.foundVersion) {
            this.foundVersion = false;
            String versionString = new String(ch, start, length);
            try {
                GrailsVersion version = new GrailsVersion(versionString);
                if (this.allowedReleaseTypes.contains((Object)version.releaseType)) {
                    this.versions.add(version);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to parse version '" + versionString + "' from maven repository.", e);
            }
        }
    }

    public List<GrailsVersion> getVersions() {
        return this.versions;
    }
}

