/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.build.gradle;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.order.Ordered;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.grails.forge.build.gradle.DefaultGradleRepository;
import org.grails.forge.build.gradle.MavenCentralRepository;
import org.grails.forge.build.gradle.VersionRegexRepoFilter;

public interface GradleRepository
extends Ordered {
    @NonNull
    public String toSnippet(String var1);

    public static Set<GradleRepository> getDefaultRepositories(String grailsVersion) {
        HashSet<GradleRepository> repositories = new HashSet<GradleRepository>();
        String overrideRepo = System.getenv("GRAILS_REPO_URL");
        if (overrideRepo != null && !overrideRepo.isEmpty()) {
            repositories.add(new DefaultGradleRepository(0, overrideRepo));
        }
        repositories.add(new MavenCentralRepository(repositories.size()));
        repositories.add(new DefaultGradleRepository(repositories.size(), "https://repo.grails.org/grails/restricted"));
        if (grailsVersion.endsWith("SNAPSHOT")) {
            repositories.add(new DefaultGradleRepository(repositories.size(), "https://repository.apache.org/content/groups/snapshots", null, List.of(new VersionRegexRepoFilter("org[.]apache[.](grails|groovy).*", ".*", ".*-SNAPSHOT"))));
            repositories.add(new DefaultGradleRepository(repositories.size(), "https://repository.apache.org/content/groups/staging", null, List.of(new VersionRegexRepoFilter("org[.]apache[.]grails[.]gradle", "grails-publish", ".*"))));
        }
        return repositories;
    }
}

