/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.test;

import io.micronaut.core.annotation.NonNull;
import jakarta.inject.Singleton;
import java.util.stream.Stream;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.Project;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.Dependency;
import org.grails.forge.build.gradle.GradlePlugin;
import org.grails.forge.feature.Feature;
import org.grails.forge.feature.FeatureContext;
import org.grails.forge.feature.FeaturePhase;
import org.grails.forge.feature.test.Spock;
import org.grails.forge.feature.test.template.gebConfig;
import org.grails.forge.feature.test.template.groovyJunit;
import org.grails.forge.feature.test.template.spock;
import org.grails.forge.feature.test.template.webdriverBinariesPlugin;
import org.grails.forge.options.DefaultTestRockerModelProvider;
import org.grails.forge.options.Language;
import org.grails.forge.template.RockerTemplate;
import org.grails.forge.template.RockerWritable;

@Singleton
public class GebWithWebDriverBinaries
implements Feature {
    private final Spock spock;

    public GebWithWebDriverBinaries(Spock spock2) {
        this.spock = spock2;
    }

    @Override
    @NonNull
    public String getName() {
        return "geb-with-webdriver-binaries";
    }

    @Override
    public String getTitle() {
        return "Geb Functional Testing using WebDriver binaries Gradle plugin";
    }

    @Override
    @NonNull
    public String getDescription() {
        return "This plugin configures Geb to use the WebDriver binaries Gradle plugin for downloading and caching the WebDriver binary for your platform.";
    }

    @Override
    public String getCategory() {
        return "Testing";
    }

    @Override
    public int getOrder() {
        return FeaturePhase.TEST.getOrder();
    }

    @Override
    public boolean supports(ApplicationType applicationType) {
        return applicationType == ApplicationType.WEB || applicationType == ApplicationType.WEB_PLUGIN;
    }

    @Override
    public String getDocumentation() {
        return "https://github.com/apache/grails-geb#readme";
    }

    @Override
    public String getThirdPartyDocumentation() {
        return "https://groovy.apache.org/geb/manual/current/";
    }

    @Override
    public void processSelectedFeatures(FeatureContext featureContext) {
        if (!featureContext.isPresent(Spock.class) && this.spock != null) {
            featureContext.addFeature(this.spock);
        }
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        generatorContext.addBuildPlugin(GradlePlugin.builder().id("org.ysb33r.webdriver-binaries").lookupArtifactId("webdriver-binaries").extension(new RockerWritable(webdriverBinariesPlugin.template(generatorContext.getProject(), generatorContext.getOperatingSystem()))).build());
        Stream.of("api", "support", "remote-driver").map(name -> "selenium-" + name).forEach(name -> generatorContext.addDependency(Dependency.builder().groupId("org.seleniumhq.selenium").artifactId((String)name).testImplementation()));
        generatorContext.addDependency(Dependency.builder().groupId("org.seleniumhq.selenium").artifactId("selenium-firefox-driver").testRuntimeOnly());
        generatorContext.addDependency(Dependency.builder().groupId("org.seleniumhq.selenium").artifactId("selenium-safari-driver").testRuntimeOnly());
        Project project = generatorContext.getProject();
        DefaultTestRockerModelProvider provider = new DefaultTestRockerModelProvider(org.grails.forge.feature.test.template.spock.template(project), groovyJunit.template(project));
        generatorContext.addTemplate("applicationTest", new RockerTemplate(generatorContext.getIntegrationTestSourcePath("/{packagePath}/{className}"), provider.findModel(Language.DEFAULT_OPTION, generatorContext.getTestFramework())));
        generatorContext.addTemplate("gebConfig", new RockerTemplate("src/integration-test/resources/GebConfig.groovy", gebConfig.template(project)));
    }
}

