/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.function.Predicate;
import org.springframework.util.Assert;

public enum ConfigurationPropertyState {
    PRESENT,
    ABSENT,
    UNKNOWN;


    static <T> ConfigurationPropertyState search(Iterable<T> source, Predicate<T> predicate) {
        Assert.notNull(source, "'source' must not be null");
        Assert.notNull(predicate, "'predicate' must not be null");
        for (T item : source) {
            if (!predicate.test(item)) continue;
            return PRESENT;
        }
        return ABSENT;
    }

    static <T> ConfigurationPropertyState search(T[] source, int startInclusive, int endExclusive, Predicate<T> predicate) {
        Assert.notNull(source, "'source' must not be null");
        Assert.notNull(predicate, "'predicate' must not be null");
        for (int i2 = startInclusive; i2 < endExclusive; ++i2) {
            if (!predicate.test(source[i2])) continue;
            return PRESENT;
        }
        return ABSENT;
    }
}

