/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.iceberg.BaseAllMetadataTableScan;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.GenericPartitionFieldSummary;
import org.apache.iceberg.InternalData;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestsTable;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StaticDataTask;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructProjection;

public class AllManifestsTable
extends BaseMetadataTable {
    public static final Types.NestedField REF_SNAPSHOT_ID = Types.NestedField.required((int)18, (String)"reference_snapshot_id", (Type)Types.LongType.get());
    @VisibleForTesting
    static final Schema MANIFEST_FILE_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)14, (String)"content", (Type)Types.IntegerType.get()), Types.NestedField.required((int)1, (String)"path", (Type)Types.StringType.get()), Types.NestedField.required((int)2, (String)"length", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"partition_spec_id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)4, (String)"added_snapshot_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"added_data_files_count", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)6, (String)"existing_data_files_count", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)7, (String)"deleted_data_files_count", (Type)Types.IntegerType.get()), Types.NestedField.required((int)15, (String)"added_delete_files_count", (Type)Types.IntegerType.get()), Types.NestedField.required((int)16, (String)"existing_delete_files_count", (Type)Types.IntegerType.get()), Types.NestedField.required((int)17, (String)"deleted_delete_files_count", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)8, (String)"partition_summaries", (Type)Types.ListType.ofRequired((int)9, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"contains_null", (Type)Types.BooleanType.get()), Types.NestedField.required((int)11, (String)"contains_nan", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)12, (String)"lower_bound", (Type)Types.StringType.get()), Types.NestedField.optional((int)13, (String)"upper_bound", (Type)Types.StringType.get())}))), REF_SNAPSHOT_ID});

    AllManifestsTable(Table table) {
        this(table, table.name() + ".all_manifests");
    }

    AllManifestsTable(Table table, String name) {
        super(table, name);
    }

    public TableScan newScan() {
        return new AllManifestsTableScan(this.table(), MANIFEST_FILE_SCHEMA);
    }

    public Schema schema() {
        return MANIFEST_FILE_SCHEMA;
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.ALL_MANIFESTS;
    }

    static StaticDataTask.Row manifestFileToRow(PartitionSpec spec, ManifestFile manifest, long referenceSnapshotId) {
        return StaticDataTask.Row.of(manifest.content().id(), manifest.path(), manifest.length(), manifest.partitionSpecId(), manifest.snapshotId(), manifest.content() == ManifestContent.DATA ? manifest.addedFilesCount() : 0, manifest.content() == ManifestContent.DATA ? manifest.existingFilesCount() : 0, manifest.content() == ManifestContent.DATA ? manifest.deletedFilesCount() : 0, manifest.content() == ManifestContent.DELETES ? manifest.addedFilesCount() : 0, manifest.content() == ManifestContent.DELETES ? manifest.existingFilesCount() : 0, manifest.content() == ManifestContent.DELETES ? manifest.deletedFilesCount() : 0, ManifestsTable.partitionSummariesToRows(spec, manifest.partitions()), referenceSnapshotId);
    }

    public static class AllManifestsTableScan
    extends BaseAllMetadataTableScan {
        AllManifestsTableScan(Table table, Schema fileSchema) {
            super(table, fileSchema, MetadataTableType.ALL_MANIFESTS);
        }

        private AllManifestsTableScan(Table table, Schema schema, TableScanContext context) {
            super(table, schema, MetadataTableType.ALL_MANIFESTS, context);
        }

        @Override
        protected TableScan newRefinedScan(Table table, Schema schema, TableScanContext context) {
            return new AllManifestsTableScan(table, schema, context);
        }

        @Override
        protected CloseableIterable<FileScanTask> doPlanFiles() {
            FileIO io = this.table().io();
            HashMap specs = Maps.newHashMap((Map)this.table().specs());
            Schema dataTableSchema = this.table().schema();
            True filter = this.shouldIgnoreResiduals() ? Expressions.alwaysTrue() : this.filter();
            SnapshotEvaluator snapshotEvaluator = new SnapshotEvaluator((Expression)filter, MANIFEST_FILE_SCHEMA.asStruct(), this.isCaseSensitive());
            Iterable filteredSnapshots = Iterables.filter((Iterable)this.table().snapshots(), x$0 -> snapshotEvaluator.eval((Snapshot)x$0));
            return CloseableIterable.withNoopClose((Iterable)Iterables.transform((Iterable)filteredSnapshots, arg_0 -> this.lambda$doPlanFiles$2(dataTableSchema, io, specs, (Expression)filter, arg_0)));
        }

        private /* synthetic */ FileScanTask lambda$doPlanFiles$2(Schema dataTableSchema, FileIO io, Map specs, Expression filter, Snapshot snap) {
            if (snap.manifestListLocation() != null) {
                return new ManifestListReadTask(dataTableSchema, io, this.schema(), specs, snap.manifestListLocation(), filter, snap.snapshotId());
            }
            return StaticDataTask.of(io.newInputFile(((BaseTable)this.table()).operations().current().metadataFileLocation()), MANIFEST_FILE_SCHEMA, this.schema(), snap.allManifests(io), manifest -> AllManifestsTable.manifestFileToRow((PartitionSpec)specs.get(manifest.partitionSpecId()), manifest, snap.snapshotId()));
        }
    }

    private static class SnapshotEvaluator {
        private final Expression boundExpr;

        private SnapshotEvaluator(Expression expr, Types.StructType structType, boolean caseSensitive) {
            this.boundExpr = Binder.bind((Types.StructType)structType, (Expression)expr, (boolean)caseSensitive);
        }

        private boolean eval(Snapshot snapshot) {
            return new SnapshotEvalVisitor().eval(snapshot);
        }

        private class SnapshotEvalVisitor
        extends ExpressionVisitors.BoundExpressionVisitor<Boolean> {
            private long snapshotId;
            private static final boolean ROWS_MIGHT_MATCH = true;
            private static final boolean ROWS_CANNOT_MATCH = false;

            private SnapshotEvalVisitor() {
            }

            private boolean eval(Snapshot snapshot) {
                this.snapshotId = snapshot.snapshotId();
                return ExpressionVisitors.visitEvaluator((Expression)SnapshotEvaluator.this.boundExpr, (ExpressionVisitors.ExpressionVisitor)this);
            }

            public Boolean alwaysTrue() {
                return true;
            }

            public Boolean alwaysFalse() {
                return false;
            }

            public Boolean not(Boolean result) {
                return result == false;
            }

            public Boolean and(Boolean leftResult, Boolean rightResult) {
                return leftResult != false && rightResult != false;
            }

            public Boolean or(Boolean leftResult, Boolean rightResult) {
                return leftResult != false || rightResult != false;
            }

            public <T> Boolean isNull(BoundReference<T> ref) {
                if (this.isSnapshotRef(ref)) {
                    return false;
                }
                return true;
            }

            public <T> Boolean notNull(BoundReference<T> ref) {
                return true;
            }

            public <T> Boolean isNaN(BoundReference<T> ref) {
                if (this.isSnapshotRef(ref)) {
                    return false;
                }
                return true;
            }

            public <T> Boolean notNaN(BoundReference<T> ref) {
                return true;
            }

            public <T> Boolean lt(BoundReference<T> ref, Literal<T> lit) {
                return this.compareSnapshotRef(ref, lit, compareResult -> compareResult < 0);
            }

            public <T> Boolean ltEq(BoundReference<T> ref, Literal<T> lit) {
                return this.compareSnapshotRef(ref, lit, compareResult -> compareResult <= 0);
            }

            public <T> Boolean gt(BoundReference<T> ref, Literal<T> lit) {
                return this.compareSnapshotRef(ref, lit, compareResult -> compareResult > 0);
            }

            public <T> Boolean gtEq(BoundReference<T> ref, Literal<T> lit) {
                return this.compareSnapshotRef(ref, lit, compareResult -> compareResult >= 0);
            }

            public <T> Boolean eq(BoundReference<T> ref, Literal<T> lit) {
                return this.compareSnapshotRef(ref, lit, compareResult -> compareResult == 0);
            }

            public <T> Boolean notEq(BoundReference<T> ref, Literal<T> lit) {
                return this.compareSnapshotRef(ref, lit, compareResult -> compareResult != 0);
            }

            public <T> Boolean in(BoundReference<T> ref, Set<T> literalSet) {
                if (this.isSnapshotRef(ref) && !literalSet.contains(this.snapshotId)) {
                    return false;
                }
                return true;
            }

            public <T> Boolean notIn(BoundReference<T> ref, Set<T> literalSet) {
                if (this.isSnapshotRef(ref) && literalSet.contains(this.snapshotId)) {
                    return false;
                }
                return true;
            }

            public <T> Boolean startsWith(BoundReference<T> ref, Literal<T> lit) {
                return true;
            }

            public <T> Boolean notStartsWith(BoundReference<T> ref, Literal<T> lit) {
                return true;
            }

            private <T> Boolean compareSnapshotRef(BoundReference<T> ref, Literal<T> lit, Function<Integer, Boolean> desiredResult) {
                Literal longLit;
                int cmp;
                if (this.isSnapshotRef(ref) && !desiredResult.apply(cmp = (longLit = lit.to((Type)Types.LongType.get())).comparator().compare(this.snapshotId, (Long)longLit.value())).booleanValue()) {
                    return false;
                }
                return true;
            }

            private <T> boolean isSnapshotRef(BoundReference<T> ref) {
                return ref.fieldId() == REF_SNAPSHOT_ID.fieldId();
            }
        }
    }

    static class ManifestListReadTask
    implements DataTask {
        private final Schema dataTableSchema;
        private final FileIO io;
        private final Schema schema;
        private final Map<Integer, PartitionSpec> specs;
        private final String manifestListLocation;
        private final Expression residual;
        private final long referenceSnapshotId;
        private DataFile lazyDataFile = null;

        ManifestListReadTask(Schema dataTableSchema, FileIO io, Schema schema, Map<Integer, PartitionSpec> specs, String manifestListLocation, Expression residual, long referenceSnapshotId) {
            this.dataTableSchema = dataTableSchema;
            this.io = io;
            this.schema = schema;
            this.specs = specs;
            this.manifestListLocation = manifestListLocation;
            this.residual = residual;
            this.referenceSnapshotId = referenceSnapshotId;
        }

        public List<DeleteFile> deletes() {
            return ImmutableList.of();
        }

        public CloseableIterable<StructLike> rows() {
            CloseableIterable closeableIterable;
            block8: {
                CloseableIterable manifests = InternalData.read(FileFormat.AVRO, this.io.newInputFile(this.manifestListLocation)).setRootType(GenericManifestFile.class).setCustomType(508, GenericPartitionFieldSummary.class).project(ManifestFile.schema()).build();
                try {
                    CloseableIterable rowIterable = CloseableIterable.transform(manifests, manifest -> AllManifestsTable.manifestFileToRow(this.specs.get(manifest.partitionSpecId()), manifest, this.referenceSnapshotId));
                    StructProjection projection = StructProjection.create((Schema)MANIFEST_FILE_SCHEMA, (Schema)this.schema);
                    closeableIterable = CloseableIterable.transform((CloseableIterable)rowIterable, arg_0 -> ((StructProjection)projection).wrap(arg_0));
                    if (manifests == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (manifests != null) {
                            try {
                                manifests.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeIOException(e, "Cannot read manifest list file: %s", new Object[]{this.manifestListLocation});
                    }
                }
                manifests.close();
            }
            return closeableIterable;
        }

        public DataFile file() {
            if (this.lazyDataFile == null) {
                this.lazyDataFile = DataFiles.builder(PartitionSpec.unpartitioned()).withInputFile(this.io.newInputFile(this.manifestListLocation)).withRecordCount(1L).withFormat(FileFormat.AVRO).build();
            }
            return this.lazyDataFile;
        }

        public PartitionSpec spec() {
            return PartitionSpec.unpartitioned();
        }

        public long start() {
            return 0L;
        }

        public long length() {
            return 8192L;
        }

        public Expression residual() {
            return this.residual;
        }

        public Iterable<FileScanTask> split(long splitSize) {
            return ImmutableList.of((Object)this);
        }

        public Schema schema() {
            return this.schema;
        }

        Schema dataTableSchema() {
            return this.dataTableSchema;
        }

        FileIO io() {
            return this.io;
        }

        Map<Integer, PartitionSpec> specsById() {
            return this.specs;
        }

        String manifestListLocation() {
            return this.manifestListLocation;
        }

        long referenceSnapshotId() {
            return this.referenceSnapshotId;
        }
    }
}

