/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.FileWriter;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class RollingFileWriter<T, W extends FileWriter<T, R>, R>
implements FileWriter<T, R> {
    private static final Logger LOG = LoggerFactory.getLogger(RollingFileWriter.class);
    private static final int ROWS_DIVISOR = 1000;
    private final OutputFileFactory fileFactory;
    private final FileIO io;
    private final long targetFileSizeInBytes;
    private final PartitionSpec spec;
    private final StructLike partition;
    private EncryptedOutputFile currentFile = null;
    private long currentFileRows = 0L;
    private W currentWriter = null;
    private boolean closed = false;

    protected RollingFileWriter(OutputFileFactory fileFactory, FileIO io, long targetFileSizeInBytes, PartitionSpec spec, StructLike partition) {
        this.fileFactory = fileFactory;
        this.io = io;
        this.targetFileSizeInBytes = targetFileSizeInBytes;
        this.spec = spec;
        this.partition = partition;
    }

    protected abstract W newWriter(EncryptedOutputFile var1);

    protected abstract void addResult(R var1);

    protected abstract R aggregatedResult();

    protected PartitionSpec spec() {
        return this.spec;
    }

    protected StructLike partition() {
        return this.partition;
    }

    public CharSequence currentFilePath() {
        return this.currentFile.encryptingOutputFile().location();
    }

    public long currentFileRows() {
        return this.currentFileRows;
    }

    @Override
    public long length() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not implement length");
    }

    @Override
    public void write(T row) {
        this.currentWriter.write(row);
        ++this.currentFileRows;
        if (this.shouldRollToNewFile()) {
            this.closeCurrentWriter();
            this.openCurrentWriter();
        }
    }

    private boolean shouldRollToNewFile() {
        return this.currentFileRows % 1000L == 0L && this.currentWriter.length() >= this.targetFileSizeInBytes;
    }

    protected void openCurrentWriter() {
        Preconditions.checkState((this.currentWriter == null ? 1 : 0) != 0, (Object)"Current writer has been already initialized");
        this.currentFile = this.newFile();
        this.currentFileRows = 0L;
        this.currentWriter = this.newWriter(this.currentFile);
    }

    private EncryptedOutputFile newFile() {
        if (this.spec.isUnpartitioned() || this.partition == null) {
            return this.fileFactory.newOutputFile();
        }
        return this.fileFactory.newOutputFile(this.spec, this.partition);
    }

    private void closeCurrentWriter() {
        if (this.currentWriter != null) {
            try {
                this.currentWriter.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to close current writer", e);
            }
            if (this.currentFileRows == 0L) {
                Tasks.foreach(this.currentFile.encryptingOutputFile()).suppressFailureWhenFinished().onFailure((file, exc) -> LOG.warn("Failed to delete the uncommitted empty file during writer clean up: {}", file, (Object)exc)).run(arg_0 -> ((FileIO)this.io).deleteFile(arg_0));
            } else {
                this.addResult(this.currentWriter.result());
            }
            this.currentFile = null;
            this.currentFileRows = 0L;
            this.currentWriter = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closeCurrentWriter();
            this.closed = true;
        }
    }

    @Override
    public final R result() {
        Preconditions.checkState((boolean)this.closed, (Object)"Cannot get result from unclosed writer");
        return this.aggregatedResult();
    }
}

