/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.util.retry;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;
import software.amazon.s3.analyticsaccelerator.util.retry.IORunnable;
import software.amazon.s3.analyticsaccelerator.util.retry.IOSupplier;
import software.amazon.s3.analyticsaccelerator.util.retry.RetryPolicy;
import software.amazon.s3.analyticsaccelerator.util.retry.RetryStrategy;
import software.amazon.s3.shaded.dev.failsafe.Failsafe;
import software.amazon.s3.shaded.dev.failsafe.FailsafeException;
import software.amazon.s3.shaded.dev.failsafe.FailsafeExecutor;
import software.amazon.s3.shaded.dev.failsafe.Policy;
import software.amazon.s3.shaded.dev.failsafe.Timeout;
import software.amazon.s3.shaded.dev.failsafe.TimeoutExceededException;

public class DefaultRetryStrategyImpl
implements RetryStrategy {
    private final List<RetryPolicy> retryPolicies;
    private Timeout<Object> timeoutPolicy;
    private boolean timeoutSet;

    public DefaultRetryStrategyImpl() {
        this.retryPolicies = new ArrayList<RetryPolicy>();
    }

    public DefaultRetryStrategyImpl(RetryPolicy outerPolicy, RetryPolicy ... policies) {
        Preconditions.checkNotNull(outerPolicy);
        this.retryPolicies = new ArrayList<RetryPolicy>();
        this.retryPolicies.add(outerPolicy);
        if (policies != null && policies.length > 0) {
            this.retryPolicies.addAll(Arrays.asList(policies));
        }
    }

    public DefaultRetryStrategyImpl(List<RetryPolicy> policies) {
        Preconditions.checkNotNull(policies);
        this.retryPolicies = new ArrayList<RetryPolicy>();
        this.retryPolicies.addAll(policies);
    }

    @Override
    public void execute(IORunnable runnable) {
        try {
            this.executor().run(runnable::apply);
        }
        catch (Exception ex) {
            throw this.handleExceptionAfterRetry(ex);
        }
    }

    @Override
    public <T> T get(IOSupplier<T> supplier) {
        try {
            return (T)this.executor().get(supplier::apply);
        }
        catch (Exception ex) {
            throw this.handleExceptionAfterRetry(ex);
        }
    }

    @Override
    public RetryStrategy amend(RetryPolicy policy) {
        Preconditions.checkNotNull(policy);
        this.retryPolicies.add(policy);
        return this;
    }

    @Override
    public RetryStrategy merge(RetryStrategy strategy) {
        Preconditions.checkNotNull(strategy);
        this.retryPolicies.addAll(strategy.getRetryPolicies());
        return this;
    }

    @Override
    public List<RetryPolicy> getRetryPolicies() {
        return this.retryPolicies;
    }

    private List<Policy<Object>> getDelegates() {
        return this.retryPolicies.stream().map(RetryPolicy::getDelegate).collect(Collectors.toList());
    }

    private Exception handleExceptionAfterRetry(Exception e) {
        Optional<Throwable> cause;
        if (e instanceof FailsafeException && (cause = Optional.ofNullable(e.getCause())).isPresent()) {
            return (Exception)cause.get();
        }
        return e;
    }

    private FailsafeExecutor<Object> executor() {
        FailsafeExecutor<Object> executor = this.retryPolicies.isEmpty() ? Failsafe.none() : Failsafe.with(this.getDelegates());
        if (this.timeoutSet) {
            executor = executor.compose(this.timeoutPolicy);
        }
        return executor;
    }

    @Override
    public void setTimeoutPolicy(long timeoutDurationMillis, int retryCount) {
        this.timeoutPolicy = Timeout.builder(Duration.ofMillis(timeoutDurationMillis)).withInterrupt().build();
        RetryPolicy timeoutRetries = RetryPolicy.builder().handle((Class<? extends Throwable>)TimeoutExceededException.class).withMaxRetries(retryCount).build();
        this.retryPolicies.add(timeoutRetries);
        this.timeoutSet = true;
    }

    @Override
    @Generated
    public boolean isTimeoutSet() {
        return this.timeoutSet;
    }
}

