/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.provider.tarball;

import java.io.IOException;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.service.api.records.Artifact;
import org.apache.hadoop.yarn.service.api.records.ConfigFile;
import org.apache.hadoop.yarn.service.conf.YarnServiceConstants;
import org.apache.hadoop.yarn.service.provider.AbstractClientProvider;

public class TarballClientProvider
extends AbstractClientProvider
implements YarnServiceConstants {
    @Override
    public void validateArtifact(Artifact artifact, String compName, FileSystem fs) throws IOException {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Artifact is not provided for component %s (nor at the global level)", compName));
        }
        if (StringUtils.isEmpty((CharSequence)artifact.getId())) {
            throw new IllegalArgumentException(String.format("Artifact id (like docker image name) is either empty or not provided for component %s (nor at the global level)", compName));
        }
        Path p = new Path(artifact.getId());
        if (!fs.exists(p)) {
            throw new IllegalArgumentException(String.format("For component %s with %s artifact, path does not exist: %s", compName, Artifact.TypeEnum.TARBALL.name(), artifact.getId()));
        }
    }

    @Override
    protected void validateConfigFile(ConfigFile configFile, String compName, FileSystem fileSystem) throws IOException {
        if (Paths.get(configFile.getDestFile(), new String[0]).isAbsolute()) {
            throw new IllegalArgumentException(String.format("For component %s with %s artifact, dest_file must be a relative path: %s", compName, Artifact.TypeEnum.TARBALL.name(), configFile.getDestFile()));
        }
    }
}

