/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.GenericsUtil;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.server.webapp.WebPageUtils;
import org.apache.hadoop.yarn.util.Log4jWarningErrorMetricsAppender;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class NavBlock
extends HtmlBlock {
    private Configuration conf;

    @Inject
    public NavBlock(Configuration conf) {
        this.conf = conf;
    }

    public void render(HtmlBlock.Block html) {
        Log4jWarningErrorMetricsAppender appender;
        boolean addErrorsAndWarningsLink = false;
        if (GenericsUtil.isLog4jLogger(NavBlock.class) && (appender = Log4jWarningErrorMetricsAppender.findAppender()) != null) {
            addErrorsAndWarningsLink = true;
        }
        Hamlet.UL mainList = (Hamlet.UL)((Hamlet.UL)((Hamlet.UL)html.div("#nav").h3("Cluster").ul().li().a(this.url(new String[]{"cluster"}), "About").__()).li().a(this.url(new String[]{"nodes"}), "Nodes").__()).li().a(this.url(new String[]{"nodelabels"}), "Node Labels").__();
        Hamlet.UL subAppsList = mainList.li().a(this.url(new String[]{"apps"}), "Applications").ul();
        subAppsList.li().__();
        for (YarnApplicationState state : YarnApplicationState.values()) {
            subAppsList.li().a(this.url(new String[]{"apps", state.toString()}), state.toString()).__();
        }
        ((Hamlet.LI)subAppsList.__()).__();
        Hamlet.DIV sectionBefore = (Hamlet.DIV)((Hamlet.UL)mainList.li().a(this.url(new String[]{"scheduler"}), "Scheduler").__()).__();
        Hamlet.UL tools = WebPageUtils.appendToolSection((Hamlet.DIV)sectionBefore, (Configuration)this.conf);
        if (tools == null) {
            return;
        }
        if (addErrorsAndWarningsLink) {
            tools.li().a(this.url(new String[]{"errors-and-warnings"}), "Errors/Warnings").__();
        }
        ((Hamlet.DIV)tools.__()).__();
    }
}

