/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.mapreduce.jobhistory.JhCounters;
import org.apache.hadoop.tools.rumen.JobHistoryUtils;
import org.apache.hadoop.tools.rumen.LoggedTaskAttempt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsedTaskAttempt
extends LoggedTaskAttempt {
    private static final Logger LOG = LoggerFactory.getLogger(ParsedTaskAttempt.class);
    private String diagnosticInfo;
    private String trackerName;
    private Integer httpPort;
    private Integer shufflePort;
    private Map<String, Long> countersMap = new HashMap<String, Long>();

    ParsedTaskAttempt() {
    }

    @Override
    public void incorporateCounters(JhCounters counters) {
        Map<String, Long> countersMap = JobHistoryUtils.extractCounters(counters);
        this.putCounters(countersMap);
        super.incorporateCounters(counters);
    }

    public void putCounters(Map<String, Long> counters) {
        this.countersMap = counters;
    }

    public Map<String, Long> obtainCounters() {
        return this.countersMap;
    }

    public void putDiagnosticInfo(String msg) {
        this.diagnosticInfo = msg;
    }

    public String obtainDiagnosticInfo() {
        return this.diagnosticInfo;
    }

    void putTrackerName(String trackerName) {
        this.trackerName = trackerName;
    }

    public String obtainTrackerName() {
        return this.trackerName;
    }

    void putHttpPort(int port) {
        this.httpPort = port;
    }

    public Integer obtainHttpPort() {
        return this.httpPort;
    }

    void putShufflePort(int port) {
        this.shufflePort = port;
    }

    public Integer obtainShufflePort() {
        return this.shufflePort;
    }

    void dumpParsedTaskAttempt() {
        LOG.info("ParsedTaskAttempt details:" + this.obtainCounters() + ";DiagnosticInfo=" + this.obtainDiagnosticInfo() + "\n" + this.obtainTrackerName() + ";" + this.obtainHttpPort() + ";" + this.obtainShufflePort() + ";rack=" + this.getHostName().getRackName() + ";host=" + this.getHostName().getHostName());
    }
}

