/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.store.MembershipStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamenodeRegistrationsRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamenodeRegistrationsResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RouterFsck {
    public static final Logger LOG = LoggerFactory.getLogger((String)RouterFsck.class.getName());
    private final Router router;
    private final InetAddress remoteAddress;
    private final PrintWriter out;
    private final Map<String, String[]> pmap;

    public RouterFsck(Router router, Map<String, String[]> pmap, PrintWriter out, InetAddress remoteAddress) {
        this.router = router;
        this.remoteAddress = remoteAddress;
        this.out = out;
        this.pmap = pmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fsck() {
        long startTime = Time.monotonicNow();
        try {
            String warnMsg = "Now FSCK to DFSRouter is unstable feature. There may be incompatible changes between releases.";
            LOG.warn(warnMsg);
            this.out.println(warnMsg);
            String msg = "Federated FSCK started by " + UserGroupInformation.getCurrentUser() + " from " + this.remoteAddress + " at " + new Date();
            LOG.info(msg);
            this.out.println(msg);
            StateStoreService stateStore = this.router.getStateStore();
            MembershipStore membership = stateStore.getRegisteredRecordStore(MembershipStore.class);
            GetNamenodeRegistrationsRequest request = GetNamenodeRegistrationsRequest.newInstance();
            GetNamenodeRegistrationsResponse response = membership.getNamenodeRegistrations(request);
            List<MembershipState> memberships = response.getNamenodeMemberships();
            Collections.sort(memberships);
            for (MembershipState nn : memberships) {
                if (nn.getState() != FederationNamenodeServiceState.ACTIVE) continue;
                try {
                    String webAddress = nn.getWebAddress();
                    this.out.write("Checking " + nn + " at " + webAddress + "\n");
                    this.remoteFsck(nn);
                }
                catch (IOException ioe) {
                    this.out.println("Cannot query " + nn + ": " + ioe.getMessage() + "\n");
                }
            }
            this.out.println("Federated FSCK ended at " + new Date() + " in " + (Time.monotonicNow() - startTime) + " milliseconds");
        }
        catch (Exception e) {
            String errMsg = "Fsck " + e.getMessage();
            LOG.warn(errMsg, (Throwable)e);
            this.out.println("Federated FSCK ended at " + new Date() + " in " + (Time.monotonicNow() - startTime) + " milliseconds");
            this.out.println(e.getMessage());
            this.out.print("\n\n" + errMsg);
        }
        finally {
            this.out.close();
        }
    }

    private void remoteFsck(MembershipState nn) throws IOException {
        String scheme = nn.getWebScheme();
        String webAddress = nn.getWebAddress();
        String args = RouterFsck.getURLArguments(this.pmap);
        URL url = new URL(scheme + "://" + webAddress + "/fsck?" + args);
        URLConnection conn = url.openConnection();
        try (InputStream is = conn.getInputStream();
             InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                this.out.write(line + "\n");
            }
        }
    }

    private static String getURLArguments(Map<String, String[]> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            String key = entry.getKey();
            String[] value = entry.getValue();
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(key);
            sb.append("=");
            sb.append(value[0]);
        }
        return sb.toString();
    }
}

