/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.routing;

import org.apache.commons.lang3.StringUtils;

public final class PartitionKeyRangeIdentity {
    private String collectionRid;
    private String partitionKeyRangeId;

    public PartitionKeyRangeIdentity(String collectionRid, String partitionKeyRangeId) {
        if (collectionRid == null) {
            throw new IllegalArgumentException("collectionRid");
        }
        if (partitionKeyRangeId == null) {
            throw new IllegalArgumentException("partitionKeyRangeId");
        }
        this.collectionRid = collectionRid;
        this.partitionKeyRangeId = partitionKeyRangeId;
    }

    public PartitionKeyRangeIdentity(String partitionKeyRangeId) {
        if (partitionKeyRangeId == null) {
            throw new IllegalArgumentException("partitionKeyRangeId");
        }
        this.partitionKeyRangeId = partitionKeyRangeId;
    }

    public static PartitionKeyRangeIdentity fromHeader(String header) {
        String[] parts = StringUtils.split((String)header, (String)",");
        if (parts.length == 2) {
            return new PartitionKeyRangeIdentity(parts[0], parts[1]);
        }
        if (parts.length == 1) {
            return new PartitionKeyRangeIdentity(parts[0]);
        }
        throw new IllegalStateException("x-ms-documentdb-partitionkeyrangeid header contains invalid value '" + header + "'");
    }

    public String toHeader() {
        if (this.collectionRid != null) {
            return String.format("%s,%s", this.collectionRid, this.partitionKeyRangeId);
        }
        return String.format("%s", this.partitionKeyRangeId);
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return other instanceof PartitionKeyRangeIdentity && ((PartitionKeyRangeIdentity)other).collectionRid.equals(this.collectionRid) && ((PartitionKeyRangeIdentity)other).partitionKeyRangeId.equals(this.partitionKeyRangeId);
    }

    public int hashCode() {
        return (this.collectionRid != null ? this.collectionRid.hashCode() : 0) * 397 ^ (this.partitionKeyRangeId != null ? this.partitionKeyRangeId.hashCode() : 0);
    }

    public String getCollectionRid() {
        return this.collectionRid;
    }

    public String getPartitionKeyRangeId() {
        return this.partitionKeyRangeId;
    }
}

