/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.jndi;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.component.Destroyable;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Logger;

public class DataSourceCloser
implements Destroyable {
    private static final Logger LOG = Log.getLogger(DataSourceCloser.class);
    final DataSource _datasource;
    final String _shutdown;

    public DataSourceCloser(DataSource datasource) {
        if (datasource == null) {
            throw new IllegalArgumentException();
        }
        this._datasource = datasource;
        this._shutdown = null;
    }

    public DataSourceCloser(DataSource datasource, String shutdownSQL) {
        if (datasource == null) {
            throw new IllegalArgumentException();
        }
        this._datasource = datasource;
        this._shutdown = shutdownSQL;
    }

    public void destroy() {
        block16: {
            try {
                if (this._shutdown == null) break block16;
                LOG.info("Shutdown datasource {}", new Object[]{this._datasource});
                try (Connection connection = this._datasource.getConnection();
                     Statement stmt = connection.createStatement();){
                    stmt.executeUpdate(this._shutdown);
                }
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
        try {
            Method close = this._datasource.getClass().getMethod("close", new Class[0]);
            LOG.info("Close datasource {}", new Object[]{this._datasource});
            close.invoke((Object)this._datasource, new Object[0]);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }
}

