/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.snapshot.SnapshotDoesNotExistException;
import org.apache.hadoop.hbase.snapshot.SnapshotExistsException;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestSnapshotClientRetries {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotClientRetries.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Logger LOG = LoggerFactory.getLogger(TestSnapshotClientRetries.class);
    @Rule
    public TableNameTestRule testTable = new TableNameTestRule();

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.master.classes", MasterSyncObserver.class.getName());
        TEST_UTIL.startMiniCluster(1);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(expected=SnapshotExistsException.class)
    public void testSnapshotAlreadyExist() throws Exception {
        String snapshotName = "testSnapshotAlreadyExist";
        TEST_UTIL.createTable(this.testTable.getTableName(), "f");
        TEST_UTIL.getAdmin().snapshot("testSnapshotAlreadyExist", this.testTable.getTableName());
        this.snapshotAndAssertOneRetry("testSnapshotAlreadyExist", this.testTable.getTableName());
    }

    @Test(expected=SnapshotDoesNotExistException.class)
    public void testCloneNonExistentSnapshot() throws Exception {
        String snapshotName = "testCloneNonExistentSnapshot";
        this.cloneAndAssertOneRetry("testCloneNonExistentSnapshot", this.testTable.getTableName());
    }

    public void snapshotAndAssertOneRetry(String snapshotName, TableName tableName) throws Exception {
        MasterSyncObserver observer = this.getMasterSyncObserver();
        observer.snapshotCount = new AtomicInteger(0);
        TEST_UTIL.getAdmin().snapshot(snapshotName, tableName);
        Assert.assertEquals((long)1L, (long)observer.snapshotCount.get());
    }

    public void cloneAndAssertOneRetry(String snapshotName, TableName tableName) throws Exception {
        MasterSyncObserver observer = this.getMasterSyncObserver();
        observer.cloneCount = new AtomicInteger(0);
        TEST_UTIL.getAdmin().cloneSnapshot(snapshotName, tableName);
        Assert.assertEquals((long)1L, (long)observer.cloneCount.get());
    }

    private MasterSyncObserver getMasterSyncObserver() {
        return (MasterSyncObserver)TEST_UTIL.getHBaseCluster().getMaster().getMasterCoprocessorHost().findCoprocessor(MasterSyncObserver.class.getName());
    }

    public static class MasterSyncObserver
    implements MasterCoprocessor,
    MasterObserver {
        volatile AtomicInteger snapshotCount = null;
        volatile AtomicInteger cloneCount = null;

        public Optional<MasterObserver> getMasterObserver() {
            return Optional.of(this);
        }

        public void preSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
            if (this.snapshotCount != null) {
                this.snapshotCount.incrementAndGet();
            }
        }

        public void preCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
            if (this.cloneCount != null) {
                this.cloneCount.incrementAndGet();
            }
        }
    }
}

