/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoStriped;
import org.apache.hadoop.hdfs.server.blockmanagement.LowRedundancyBlocks;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestLowRedundancyBlockQueues {
    private final ErasureCodingPolicy ecPolicy;
    private static AtomicLong mockINodeId = new AtomicLong(0L);

    public TestLowRedundancyBlockQueues(ErasureCodingPolicy policy) {
        this.ecPolicy = policy;
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> policies() {
        return StripedFileTestUtil.getECPolicies();
    }

    private BlockInfo genBlockInfo(long id) {
        return this.genBlockInfo(id, false);
    }

    private BlockInfo genBlockInfo(long id, boolean isCorruptBlock) {
        BlockInfoContiguous bInfo = new BlockInfoContiguous(new Block(id), 3);
        if (!isCorruptBlock) {
            bInfo.setBlockCollectionId(mockINodeId.incrementAndGet());
        }
        return bInfo;
    }

    private BlockInfo genStripedBlockInfo(long id, long numBytes) {
        BlockInfoStriped sblk = new BlockInfoStriped(new Block(id), this.ecPolicy);
        sblk.setNumBytes(numBytes);
        return sblk;
    }

    private void verifyBlockStats(LowRedundancyBlocks queues, int lowRedundancyReplicaCount, int corruptReplicaCount, int corruptReplicationOneCount, int lowRedundancyStripedCount, int corruptStripedCount, int highestPriorityReplicatedBlockCount, int highestPriorityECBlockCount) {
        Assert.assertEquals((String)"Low redundancy replica count incorrect!", (long)lowRedundancyReplicaCount, (long)queues.getLowRedundancyBlocks());
        Assert.assertEquals((String)"Corrupt replica count incorrect!", (long)corruptReplicaCount, (long)queues.getCorruptBlocks());
        Assert.assertEquals((String)"Corrupt replica one count incorrect!", (long)corruptReplicationOneCount, (long)queues.getCorruptReplicationOneBlocks());
        Assert.assertEquals((String)"Low redundancy striped blocks count incorrect!", (long)lowRedundancyStripedCount, (long)queues.getLowRedundancyECBlockGroups());
        Assert.assertEquals((String)"Corrupt striped blocks count incorrect!", (long)corruptStripedCount, (long)queues.getCorruptECBlockGroups());
        Assert.assertEquals((String)"Low Redundancy count incorrect!", (long)(lowRedundancyReplicaCount + lowRedundancyStripedCount), (long)queues.getLowRedundancyBlockCount());
        Assert.assertEquals((String)"LowRedundancyBlocks queue size incorrect!", (long)(lowRedundancyReplicaCount + corruptReplicaCount + lowRedundancyStripedCount + corruptStripedCount), (long)queues.size());
        Assert.assertEquals((String)"Highest priority replicated low redundancy blocks count is incorrect!", (long)highestPriorityReplicatedBlockCount, (long)queues.getHighestPriorityReplicatedBlockCount());
        Assert.assertEquals((String)"Highest priority erasure coded low redundancy blocks count is incorrect!", (long)highestPriorityECBlockCount, (long)queues.getHighestPriorityECBlockCount());
    }

    @Test
    public void testDeletedBlocks() throws Exception {
        int numBlocks = 5;
        LowRedundancyBlocks queues = new LowRedundancyBlocks();
        for (int ind = 0; ind < numBlocks; ++ind) {
            BlockInfo blockInfo = this.genBlockInfo(ind, ind == 0);
            queues.add(blockInfo, 2, 0, 0, 3);
        }
        List blocks = queues.chooseLowRedundancyBlocks(2, false);
        Assert.assertEquals((long)1L, (long)((List)blocks.get(2)).size());
        Assert.assertEquals((long)1L, (long)((BlockInfo)((List)blocks.get(2)).get(0)).getBlockId());
        blocks = queues.chooseLowRedundancyBlocks(1, false);
        Assert.assertEquals((long)2L, (long)((BlockInfo)((List)blocks.get(2)).get(0)).getBlockId());
        blocks = queues.chooseLowRedundancyBlocks(1, true);
        Assert.assertEquals((long)3L, (long)((BlockInfo)((List)blocks.get(2)).get(0)).getBlockId());
        blocks = queues.chooseLowRedundancyBlocks(1, false);
        Assert.assertEquals((long)1L, (long)((BlockInfo)((List)blocks.get(2)).get(0)).getBlockId());
    }

    @Test
    public void testQueuePositionCanBeReset() throws Throwable {
        LowRedundancyBlocks queues = new LowRedundancyBlocks();
        for (int i = 0; i < 4; ++i) {
            BlockInfo block = this.genBlockInfo(i);
            queues.add(block, 2, 0, 0, 3);
        }
        List blocks = queues.chooseLowRedundancyBlocks(1, false);
        Assert.assertEquals((long)1L, (long)((List)blocks.get(2)).size());
        Assert.assertEquals((long)0L, (long)((BlockInfo)((List)blocks.get(2)).get(0)).getBlockId());
        blocks = queues.chooseLowRedundancyBlocks(1, false);
        Assert.assertEquals((long)1L, (long)((BlockInfo)((List)blocks.get(2)).get(0)).getBlockId());
        blocks = queues.chooseLowRedundancyBlocks(1, true);
        Assert.assertEquals((long)2L, (long)((BlockInfo)((List)blocks.get(2)).get(0)).getBlockId());
        blocks = queues.chooseLowRedundancyBlocks(1, false);
        Assert.assertEquals((long)0L, (long)((BlockInfo)((List)blocks.get(2)).get(0)).getBlockId());
    }

    @Test
    public void testBlockPriorities() throws Throwable {
        LowRedundancyBlocks queues = new LowRedundancyBlocks();
        BlockInfo block1 = this.genBlockInfo(1L);
        BlockInfo block2 = this.genBlockInfo(2L);
        BlockInfo block_very_low_redundancy = this.genBlockInfo(3L);
        BlockInfo block_corrupt = this.genBlockInfo(4L);
        BlockInfo block_corrupt_repl_one = this.genBlockInfo(5L);
        this.assertAdded(queues, block1, 1, 0, 3);
        this.assertInLevel(queues, (Block)block1, 0);
        this.verifyBlockStats(queues, 1, 0, 0, 0, 0, 1, 0);
        Assert.assertFalse((boolean)queues.add(block1, 1, 0, 0, 3));
        this.verifyBlockStats(queues, 1, 0, 0, 0, 0, 1, 0);
        this.assertAdded(queues, block2, 2, 0, 3);
        this.assertInLevel(queues, (Block)block2, 2);
        this.verifyBlockStats(queues, 2, 0, 0, 0, 0, 1, 0);
        this.assertAdded(queues, block_corrupt, 0, 0, 3);
        this.assertInLevel(queues, (Block)block_corrupt, 4);
        this.verifyBlockStats(queues, 2, 1, 0, 0, 0, 1, 0);
        this.assertAdded(queues, block_very_low_redundancy, 4, 0, 25);
        this.assertInLevel(queues, (Block)block_very_low_redundancy, 1);
        this.verifyBlockStats(queues, 3, 1, 0, 0, 0, 1, 0);
        this.assertAdded(queues, block_corrupt_repl_one, 0, 0, 1);
        this.verifyBlockStats(queues, 3, 2, 1, 0, 0, 1, 0);
        queues.update(block_corrupt_repl_one, 0, 0, 0, 3, 0, 2);
        this.verifyBlockStats(queues, 3, 2, 0, 0, 0, 1, 0);
        queues.update(block_corrupt, 0, 0, 0, 1, 0, -2);
        this.verifyBlockStats(queues, 3, 2, 1, 0, 0, 1, 0);
        queues.update(block_very_low_redundancy, 0, 0, 0, 1, -4, -24);
        this.verifyBlockStats(queues, 2, 3, 2, 0, 0, 1, 0);
        queues.update(block1, 1, 0, 0, 1, 0, 0);
        this.verifyBlockStats(queues, 2, 3, 2, 0, 0, 0, 0);
    }

    @Test
    public void testRemoveWithWrongPriority() {
        LowRedundancyBlocks queues = new LowRedundancyBlocks();
        BlockInfo corruptBlock = this.genBlockInfo(1L);
        this.assertAdded(queues, corruptBlock, 0, 0, 3);
        this.assertInLevel(queues, (Block)corruptBlock, 4);
        this.verifyBlockStats(queues, 0, 1, 0, 0, 0, 0, 0);
        queues.remove(corruptBlock, 2);
        this.verifyBlockStats(queues, 0, 0, 0, 0, 0, 0, 0);
    }

    @Test
    public void testStripedBlockPriorities() throws Throwable {
        int dataBlkNum = this.ecPolicy.getNumDataUnits();
        int parityBlkNUm = this.ecPolicy.getNumParityUnits();
        this.doTestStripedBlockPriorities(1, parityBlkNUm);
        this.doTestStripedBlockPriorities(dataBlkNum, parityBlkNUm);
    }

    private void doTestStripedBlockPriorities(int dataBlkNum, int parityBlkNum) throws Throwable {
        int groupSize = dataBlkNum + parityBlkNum;
        long numBytes = this.ecPolicy.getCellSize() * dataBlkNum;
        LowRedundancyBlocks queues = new LowRedundancyBlocks();
        int numUR = 0;
        int numCorrupt = 0;
        int i = 0;
        while (dataBlkNum + i < groupSize) {
            BlockInfo block = this.genStripedBlockInfo(-100 - 100 * i, numBytes);
            this.assertAdded(queues, block, dataBlkNum + i, 0, groupSize);
            Assert.assertEquals((long)(++numUR), (long)queues.getLowRedundancyBlockCount());
            Assert.assertEquals((long)(numUR + numCorrupt), (long)queues.size());
            if (i == 0) {
                this.assertInLevel(queues, (Block)block, 0);
            } else if (i * 3 < parityBlkNum + 1) {
                this.assertInLevel(queues, (Block)block, 1);
            } else {
                this.assertInLevel(queues, (Block)block, 2);
            }
            this.verifyBlockStats(queues, 0, 0, 0, numUR, 0, 0, 1);
            ++i;
        }
        BlockInfo block_corrupt = this.genStripedBlockInfo(-10L, numBytes);
        Assert.assertEquals((long)numCorrupt, (long)queues.getCorruptBlockSize());
        this.verifyBlockStats(queues, 0, 0, 0, numUR, numCorrupt, 0, 1);
        this.assertAdded(queues, block_corrupt, dataBlkNum - 1, 0, groupSize);
        this.verifyBlockStats(queues, 0, 0, 0, numUR, ++numCorrupt, 0, 1);
        this.assertInLevel(queues, (Block)block_corrupt, 4);
    }

    private void assertAdded(LowRedundancyBlocks queues, BlockInfo block, int curReplicas, int decommissionedReplicas, int expectedReplicas) {
        Assert.assertTrue((String)("Failed to add " + block), (boolean)queues.add(block, curReplicas, 0, decommissionedReplicas, expectedReplicas));
    }

    private void assertInLevel(LowRedundancyBlocks queues, Block block, int level) {
        Iterator bi = queues.iterator(level);
        while (bi.hasNext()) {
            Block next = (Block)bi.next();
            if (!block.equals((Object)next)) continue;
            return;
        }
        Assert.fail((String)("Block " + block + " not found in level " + level));
    }

    @Test
    public void testRemoveBlockInManyQueues() {
        LowRedundancyBlocks neededReconstruction = new LowRedundancyBlocks();
        BlockInfoContiguous block = new BlockInfoContiguous(new Block(), 1024);
        neededReconstruction.add((BlockInfo)block, 2, 0, 1, 3);
        neededReconstruction.add((BlockInfo)block, 0, 0, 0, 3);
        neededReconstruction.remove((BlockInfo)block, 5);
        Assert.assertFalse((String)"Should not contain the block.", (boolean)neededReconstruction.contains((BlockInfo)block));
    }
}

