/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.LazyPersistTestCase;
import org.apache.hadoop.test.GenericTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class TestLazyPersistReplicaPlacement
extends LazyPersistTestCase {
    @Test
    public void testPlacementOnRamDisk() throws IOException, TimeoutException, InterruptedException {
        this.getClusterBuilder().build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path, StorageType.RAM_DISK);
    }

    @Test
    public void testPlacementOnSizeLimitedRamDisk() throws IOException, TimeoutException, InterruptedException {
        this.getClusterBuilder().setRamDiskReplicaCapacity(3).build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        Path path2 = new Path("/" + METHOD_NAME + ".02.dat");
        this.makeTestFile(path1, 0x500000L, true);
        this.makeTestFile(path2, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        this.ensureFileReplicasOnStorageType(path2, StorageType.RAM_DISK);
    }

    @Test
    public void testFallbackToDisk() throws IOException, TimeoutException, InterruptedException {
        this.getClusterBuilder().setHasTransientStorage(false).build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path, StorageType.DEFAULT);
    }

    @Test
    public void testSynchronousEviction() throws Exception {
        this.getClusterBuilder().setMaxLockedMemory(0x500000L).build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        this.makeTestFile(path1, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        this.waitForMetric("RamDiskBlocksLazyPersisted", 1);
        Path path2 = new Path("/" + METHOD_NAME + ".02.dat");
        this.makeTestFile(path2, 0x500000L, true);
        this.verifyRamDiskJMXMetric("RamDiskBlocksEvictedWithoutRead", 1L);
    }

    @Test
    public void testFallbackToDiskFull() throws Exception {
        this.getClusterBuilder().setMaxLockedMemory(0x280000L).build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path, StorageType.DEFAULT);
        this.verifyRamDiskJMXMetric("RamDiskBlocksWriteFallback", 1L);
    }

    @Test
    public void testFallbackToDiskPartial() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().setMaxLockedMemory(0xA00000L).build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0x1900000L, true);
        Thread.sleep(6000L);
        this.triggerBlockReport();
        int numBlocksOnRamDisk = 0;
        int numBlocksOnDisk = 0;
        long fileLength = this.client.getFileInfo(path.toString()).getLen();
        LocatedBlocks locatedBlocks = this.client.getLocatedBlocks(path.toString(), 0L, fileLength);
        for (LocatedBlock locatedBlock : locatedBlocks.getLocatedBlocks()) {
            if (locatedBlock.getStorageTypes()[0] == StorageType.RAM_DISK) {
                ++numBlocksOnRamDisk;
                continue;
            }
            if (locatedBlock.getStorageTypes()[0] != StorageType.DEFAULT) continue;
            ++numBlocksOnDisk;
        }
        MatcherAssert.assertThat((Object)numBlocksOnRamDisk, (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)numBlocksOnDisk, (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testRamDiskNotChosenByDefault() throws IOException {
        this.getClusterBuilder().setStorageTypes(new StorageType[]{StorageType.RAM_DISK, StorageType.RAM_DISK}).build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        try {
            this.makeTestFile(path, 0x500000L, false);
            Assert.fail((String)"Block placement to RAM_DISK should have failed without lazyPersist flag");
        }
        catch (Throwable t) {
            LOG.info("Got expected exception ", t);
        }
    }
}

