/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import org.apache.hadoop.hive.common.cli.EscapeCRLFHelper;
import org.apache.hive.beeline.BeeLine;

abstract class Rows
implements Iterator {
    protected final BeeLine beeLine;
    final ResultSetMetaData rsMeta;
    final NumberFormat numberFormat;
    private boolean convertBinaryArrayToString;
    private final String nullStr;

    Rows(BeeLine beeLine, ResultSet rs) throws SQLException {
        this.beeLine = beeLine;
        this.nullStr = beeLine.getOpts().getNullString();
        this.rsMeta = rs.getMetaData();
        this.numberFormat = beeLine.getOpts().getNumberFormat().equals("default") ? null : new DecimalFormat(beeLine.getOpts().getNumberFormat());
        this.convertBinaryArrayToString = beeLine.getOpts().getConvertBinaryArrayToString();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    abstract void normalizeWidths();

    class Row {
        final String[] values;
        final boolean isMeta;
        boolean deleted;
        boolean inserted;
        boolean updated;
        int[] sizes;

        Row(Rows this$0, int size) throws SQLException {
            this.isMeta = true;
            this.values = new String[size];
            this.sizes = new int[size];
            for (int i = 0; i < size; ++i) {
                this.values[i] = this$0.rsMeta.getColumnLabel(i + 1);
                this.sizes[i] = this.values[i] == null ? 1 : this.values[i].length();
            }
            this.deleted = false;
            this.updated = false;
            this.inserted = false;
        }

        public String toString() {
            return Arrays.asList(this.values).toString();
        }

        Row(Rows this$0, int size, ResultSet rs) throws SQLException {
            this.isMeta = false;
            this.values = new String[size];
            this.sizes = new int[size];
            try {
                this.deleted = rs.rowDeleted();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.updated = rs.rowUpdated();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.inserted = rs.rowInserted();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (int i = 0; i < size; ++i) {
                Object o = rs.getObject(i + 1);
                String value = null;
                value = o == null ? this$0.nullStr : (o instanceof Number ? (this$0.numberFormat != null ? this$0.numberFormat.format(o) : (o instanceof BigDecimal ? ((BigDecimal)o).toPlainString() : o.toString())) : (o instanceof byte[] ? (this$0.convertBinaryArrayToString ? new String((byte[])o, StandardCharsets.UTF_8) : Base64.getEncoder().withoutPadding().encodeToString((byte[])o)) : rs.getString(i + 1)));
                if (this$0.beeLine.getOpts().getEscapeCRLF()) {
                    value = EscapeCRLFHelper.escapeCRLF((String)value);
                }
                this.values[i] = value.intern();
                this.sizes[i] = value.length();
            }
        }
    }
}

