/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.BrotliDecompressingEntity;
import org.apache.hc.client5.http.entity.BrotliInputStreamFactory;
import org.apache.hc.client5.http.entity.DecompressingEntity;
import org.apache.hc.client5.http.entity.DeflateInputStreamFactory;
import org.apache.hc.client5.http.entity.GZIPInputStreamFactory;
import org.apache.hc.client5.http.entity.InputStreamFactory;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.message.BasicHeaderValueParser;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class ContentCompressionExec
implements ExecChainHandler {
    public static final int MAX_CODEC_LIST_LEN = 5;
    private final Header acceptEncoding;
    private final Lookup<InputStreamFactory> decoderRegistry;
    private final boolean ignoreUnknown;
    private final int maxCodecListLen;

    public ContentCompressionExec(List<String> acceptEncoding, Lookup<InputStreamFactory> decoderRegistry, boolean ignoreUnknown, int maxCodecListLen) {
        boolean brotliSupported;
        boolean bl = brotliSupported = decoderRegistry == null && BrotliDecompressingEntity.isAvailable();
        if (acceptEncoding != null) {
            this.acceptEncoding = MessageSupport.headerOfTokens((String)"Accept-Encoding", acceptEncoding);
        } else {
            ArrayList<String> encodings = new ArrayList<String>(4);
            encodings.add("gzip");
            encodings.add("x-gzip");
            encodings.add("deflate");
            if (brotliSupported) {
                encodings.add("br");
            }
            this.acceptEncoding = MessageSupport.headerOfTokens((String)"Accept-Encoding", encodings);
        }
        if (decoderRegistry != null) {
            this.decoderRegistry = decoderRegistry;
        } else {
            RegistryBuilder builder = RegistryBuilder.create().register("gzip", (Object)GZIPInputStreamFactory.getInstance()).register("x-gzip", (Object)GZIPInputStreamFactory.getInstance()).register("deflate", (Object)DeflateInputStreamFactory.getInstance());
            if (brotliSupported) {
                builder.register("br", (Object)BrotliInputStreamFactory.getInstance());
            }
            this.decoderRegistry = builder.build();
        }
        this.ignoreUnknown = ignoreUnknown;
        this.maxCodecListLen = maxCodecListLen;
    }

    public ContentCompressionExec(List<String> acceptEncoding, Lookup<InputStreamFactory> decoderRegistry, boolean ignoreUnknown) {
        this(acceptEncoding, decoderRegistry, ignoreUnknown, 5);
    }

    public ContentCompressionExec(boolean ignoreUnknown) {
        this(null, null, ignoreUnknown, 5);
    }

    public ContentCompressionExec(int maxCodecListLen) {
        this(null, null, true, maxCodecListLen);
    }

    public ContentCompressionExec() {
        this(null, null, true, 5);
    }

    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        String contentEncoding;
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)scope, (String)"Scope");
        HttpClientContext clientContext = scope.clientContext;
        RequestConfig requestConfig = clientContext.getRequestConfigOrDefault();
        if (!request.containsHeader("Accept-Encoding") && requestConfig.isContentCompressionEnabled()) {
            request.addHeader(this.acceptEncoding);
        }
        ClassicHttpResponse response = chain.proceed(request, scope);
        HttpEntity entity = response.getEntity();
        if (requestConfig.isContentCompressionEnabled() && entity != null && entity.getContentLength() != 0L && (contentEncoding = entity.getContentEncoding()) != null) {
            ParserCursor cursor = new ParserCursor(0, contentEncoding.length());
            HeaderElement[] codecs = BasicHeaderValueParser.INSTANCE.parseElements((CharSequence)contentEncoding, cursor);
            if (this.maxCodecListLen > 0 && codecs.length > this.maxCodecListLen) {
                throw new ProtocolException("Codec list exceeds maximum of " + this.maxCodecListLen + " elements");
            }
            for (HeaderElement codec : codecs) {
                String codecname = codec.getName().toLowerCase(Locale.ROOT);
                InputStreamFactory decoderFactory = (InputStreamFactory)this.decoderRegistry.lookup(codecname);
                if (decoderFactory != null) {
                    response.setEntity((HttpEntity)new DecompressingEntity(response.getEntity(), decoderFactory));
                    response.removeHeaders("Content-Length");
                    response.removeHeaders("Content-Encoding");
                    response.removeHeaders("Content-MD5");
                    continue;
                }
                if ("identity".equals(codecname) || this.ignoreUnknown) continue;
                throw new HttpException("Unsupported Content-Encoding: " + codec.getName());
            }
        }
        return response;
    }
}

